<?php

add_action( 'tgmpa_register', 'mojito_register_required_plugins' );

function mojito_register_required_plugins() {

    $plugins = [
        [
            'name'               => esc_html__( 'Mojito Core', 'mojito' ),
            'slug'               => 'mojito-core',
            'source'             => esc_url( 'https://themexriver.com/wp/mojito/mojito-plug/mojito-core.zip' ),
            'external_url'       => esc_url( 'https://themexriver.com/wp/mojito/mojito-plug/mojito-core.zip' ),
            'required'           => true,
            'force_activation'   => false,
            'force_deactivation' => false,
        ],
        [
            'name'     => esc_html__( 'Elementor Page Builder', 'mojito' ),
            'slug'     => 'elementor',
            'required' => true,
        ],
        [
            'name'     => esc_html__( 'WP Classic Editor', 'mojito' ),
            'slug'     => 'classic-editor',
            'required' => false,
        ],
        [
            'name'     => esc_html__( 'Contact Form 7', 'mojito' ),
            'slug'     => 'contact-form-7',
            'required' => true,
        ],
        [
            'name'     => esc_html__( 'WooCommerce', 'mojito' ),
            'slug'     => 'woocommerce',
            'required' => true,
        ],
        [
            'name'     => esc_html__( 'One Click Demo Import', 'mojito' ),
            'slug'     => 'one-click-demo-import',
            'required' => false,
        ],
        [
            'name'     => esc_html__( 'SVG Support', 'mojito' ),
            'slug'     => 'svg-support',
            'required' => false,
        ],

    ];

    $config = [
        'id'           => 'mojito',
        'parent_slug'  => 'mojito',
        'menu'         => 'tgmpa-install-plugins',
        'dismissable'  => true,
        'dismiss_msg'  => '',
        'is_automatic' => false,
        'message'      => '',
        'default_path' => '',
    ];

    tgmpa( $plugins, $config );
}
