<?php
// mojito_search_filter_form
if ( !function_exists( 'mojito_search_filter_form' ) ) {
    function mojito_search_filter_form( $form ) {

        $form = sprintf(
            '<div class="search-widget"><form class="tx-search-widget tx-input-field pf-sidebar-search" action="%s" method="get">
                <input type="search" value="%s" required name="s" placeholder="%s" class="pf-sidebar-search-input">
                <button type="submit" aria-label="search" class="pf-sidebar-search-btn"><i class="fa-solid fa-magnifying-glass"></i></button>
		    </form></div>',
            esc_url( home_url( '/' ) ),
            esc_attr( get_search_query() ),
            esc_html__( 'Search...', 'mojito' )
        );

        return $form;
    }
    add_filter( 'get_search_form', 'mojito_search_filter_form' );
    add_filter('render_block_core/search', 'mojito_search_filter_form');
}


// woocommerce search widget form
if ( MOJITO_WOOCOMMERCE_ACTIVED && !function_exists( 'mojito_woocommerce_product_search' ) ) {
    function mojito_woocommerce_product_search( $form ) {

        $form = sprintf(
            '<div class="search-widget"><form class="tx-search-widget tx-input-field pf-sidebar-search" action="%s" method="get">
                <input type="search" value="%s" required name="s" placeholder="%s" class="pf-sidebar-search-input">
                <button type="submit" aria-label="search" class="pf-sidebar-search-btn"><i class="fa-solid fa-magnifying-glass"></i></button>
            </form></div>',
            esc_url( home_url( '/' ) ),
            esc_attr( get_search_query() ),
            esc_html__( 'Search...', 'mojito' )
        );

        return $form;
    }
    add_filter( 'get_product_search_form', 'mojito_woocommerce_product_search' );
    add_filter('render_block_core/search', 'mojito_woocommerce_product_search');
}