<?php

/**
 * mojito_scripts description
 * @return [type] [description]
 */
function mojito_scripts() {

    wp_enqueue_style( 'mojito-fonts', mojito_fonts_url(), [], null );
    wp_enqueue_style( 'bootstrap-min', MOJITO_THEME_CSS_DIR . 'bootstrap.min.css', [] );
    wp_enqueue_style( 'fontawesome-min', MOJITO_THEME_CSS_DIR . 'fontawesome-min.css', [] );
    wp_enqueue_style( 'flaticon', MOJITO_THEME_CSS_DIR . 'flaticon.css', [] );
    wp_enqueue_style( 'animate-min', MOJITO_THEME_CSS_DIR . 'animate-min.css', [], VERSION );
    wp_enqueue_style( 'swiper-min', MOJITO_THEME_CSS_DIR . 'swiper.min.css', [], VERSION );
    wp_enqueue_style( 'jquery-ui', MOJITO_THEME_CSS_DIR . 'jquery-ui.css', [], VERSION );
    wp_enqueue_style( 'magnific-popup', MOJITO_THEME_CSS_DIR . 'magnific-popup.css', [], VERSION );
    // THEME REQUIRED CSS
    wp_enqueue_style( 'mojito-core', MOJITO_THEME_CSS_DIR . 'mojito-core.css', [], VERSION );
    wp_enqueue_style( 'mojito-companion', MOJITO_THEME_CSS_DIR . 'mojito-companion.css', [] );
    wp_enqueue_style( 'mojito-extra', MOJITO_THEME_CSS_DIR . 'mojito-extra.css', [] );
    wp_enqueue_style( 'mojito-custom', MOJITO_THEME_CSS_DIR . 'mojito-custom.css', [] );
    wp_enqueue_style( 'mojito-woocommerce', MOJITO_THEME_CSS_DIR . 'mojito-woocommerce.css', [] );
    wp_enqueue_style( 'mojito-style', get_stylesheet_uri() );

    if ( class_exists('WooCommerce') ) {
		wp_enqueue_style( 'woocommerce-style', get_template_directory_uri() . '/woocommerce/woocommerce.css' );
	}

    $my_current_lang = apply_filters( 'wpml_current_language', NULL );

    $enable_rtl = cs_get_option( 'enable_rtl', false );
    if ( $my_current_lang != 'en' && $enable_rtl || is_rtl() ) {
        wp_enqueue_style( 'mojito-rtl', MOJITO_THEME_CSS_DIR . 'mojito-rtl.css', [] );
    }

    // all js files
    wp_enqueue_script( 'bootstrap-min', MOJITO_THEME_JS_DIR . 'bootstrap-min.js', ['jquery'], false, true );
    wp_enqueue_script( 'swiper-min', MOJITO_THEME_JS_DIR . 'swiper.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'wow-min', MOJITO_THEME_JS_DIR . 'wow-min.js', ['jquery'], false, true );
    wp_enqueue_script( 'appear', MOJITO_THEME_JS_DIR . 'appear.js', ['jquery'], false, true );
    wp_enqueue_script( 'gsap-min', MOJITO_THEME_JS_DIR . 'gsap.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'knob', MOJITO_THEME_JS_DIR . 'knob.js', ['jquery'], false, true );
    wp_enqueue_script( 'jquery-ui-core', ['jquery'], false, true );
    wp_enqueue_script( 'imagesloaded', ['jquery'], false, true );
    wp_enqueue_script( 'jquery-masonry', ['jquery'], false, true );
    wp_enqueue_script( 'magnific-popup-min', MOJITO_THEME_JS_DIR . 'magnific-popup.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'jquery-marquee-min', MOJITO_THEME_JS_DIR . 'jquery.marquee.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'isotope-pkgd-min', MOJITO_THEME_JS_DIR . 'isotope.pkgd.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'counterup-min', MOJITO_THEME_JS_DIR . 'counterup.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'waypoints-min', MOJITO_THEME_JS_DIR . 'waypoints.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'lenis-min', MOJITO_THEME_JS_DIR . 'lenis.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'split-type-min', MOJITO_THEME_JS_DIR . 'split-type.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'scrollTrigger-min', MOJITO_THEME_JS_DIR . 'scrollTrigger.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'SplitText-min', MOJITO_THEME_JS_DIR . 'SplitText.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'touchspin', MOJITO_THEME_JS_DIR . 'touchspin.js', ['jquery'], false, true );
    wp_enqueue_script( 'mojito-custom', MOJITO_THEME_JS_DIR . 'mojito-custom.js', ['jquery'], false, true );

    if ( $my_current_lang != 'en' && $enable_rtl || is_rtl() ) {
        wp_enqueue_script( 'mojito-core-rtl', MOJITO_THEME_JS_DIR . 'mojito-core-rtl.js', ['jquery'], VERSION, true );
    } else {
        wp_enqueue_script( 'mojito-core', MOJITO_THEME_JS_DIR . 'mojito-core.js', ['jquery'], VERSION, true );
    }

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }

}
add_action( 'wp_enqueue_scripts', 'mojito_scripts' );
