<?php

// File Security Check
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

function mojito_primary_color() {

    wp_enqueue_style( 'mojito-primary-color', MOJITO_THEME_CSS_DIR . 'mojito-custom.css', [] );

    $theme_color_1 = cs_get_option( 'theme_color_1', '#2AC8D3' );
    $theme_color_2 = cs_get_option( 'theme_color_2', '#FF2727' );
    $theme_color_3 = cs_get_option( 'theme_color_3', '#8882EE' );
    $theme_color_4 = cs_get_option( 'theme_color_4', '#8B5BFA' );
    $theme_color_5 = cs_get_option( 'theme_color_5', '#FF2759' );
    $theme_color_6 = cs_get_option( 'theme_color_6', '#EA2B2B' );

    $id = get_the_ID();
    $page_meta = get_post_meta( $id, 'tx_page_meta', true ) ? get_post_meta( $id, 'tx_page_meta', true ) : [];

    // page_scrollbar_color
    $page_scroll_color = array_key_exists( 'page_scroll_color', $page_meta ) ? $page_meta['page_scroll_color'] : '#2ac8d3';

    if (
        $theme_color_1 ||
        $theme_color_2 ||
        $theme_color_3 ||
        $theme_color_4 ||
        $theme_color_5 ||
        $theme_color_6
    ) {
        $custom_css = '';
        $custom_css .= '
            :root {
                --pf-clr-pr-1: ' . esc_attr( $theme_color_1 ) . ';
                --pf-clr-pr-2: ' . esc_attr( $theme_color_2 ) . ';
                --pf-clr-pr-3: ' . esc_attr( $theme_color_3 ) . ';
                --pf-clr-pr-4: ' . esc_attr( $theme_color_4 ) . ';
                --pf-clr-pr-5: ' . esc_attr( $theme_color_5 ) . ';
                --pf-clr-pr-6: ' . esc_attr( $theme_color_6 ) . ';
            }
        ';

        wp_add_inline_style( 'mojito-primary-color', $custom_css );
    }

    if (
        $page_scroll_color
    ) {
        $custom_css = '';
        $custom_css .= '
            ::-webkit-scrollbar-thumb {
                background-color: ' . esc_attr( $page_scroll_color ) . ';
            }
        ';

        wp_add_inline_style( 'mojito-primary-color', $custom_css );
    }

}
add_action( 'wp_enqueue_scripts', 'mojito_primary_color' );