<?php

add_filter( 'comment_form_default_fields', 'mojito_comment_form_default_fields_func' );

function mojito_comment_form_default_fields_func( $default ) {

    $default['author'] = '
                <div class="input-field">
                    <label class="pf-form-1-label" for="name">' . esc_attr__( 'Full name', 'mojito' ) . '</label>
                    <input class="pf-form-1-input" type="text" name="author" placeholder="' . esc_attr__( 'Full Name', 'mojito' ) . '">
                </div>
                ';

    $default['email'] = '
                <div class="input-field">
                    <label class="pf-form-1-label" for="email">' . esc_attr__( 'Email', 'mojito' ) . '</label>
                    <input class="pf-form-1-input" type="text" name="email" placeholder="' . esc_attr__( 'info@mojitoindustry.co.uk', 'mojito' ) . '">
                </div>
        ';

    $default['url'] = '
                <div class="input-field">
                    <label class="pf-form-1-label" for="url">' . esc_attr__( 'Website', 'mojito' ) . '</label>
                    <input class="pf-form-1-input" type="text" name="url" placeholder="' . esc_attr__( 'Your Website...', 'mojito' ) . '">
                </div>
        ';
    return $default;
}

add_action( 'comment_form_top', 'mojito_add_comments_textarea' );
function mojito_add_comments_textarea() {
    if ( !is_user_logged_in() && function_exists( 'is_product' ) ) {
        echo '<div class="col-xl-12 hideOn-product-details form-group mb-0">
        <div class="tx-input-field input-field  mb-20">
            <label class="pf-form-1-label" for="message">' . esc_attr__( 'message', 'mojito' ) . '</label>
            <textarea class="pf-form-1-input" placeholder="' . esc_attr__( 'Write your message here...', 'mojito' ) . '"></textarea>
        </div>
    </div>';
    }
}

add_filter( 'comment_form_defaults', 'mojito_comment_form_defaults_func' );

function mojito_comment_form_defaults_func( $info ) {
    if ( !is_user_logged_in() ) {

        $info['comment_field'] = '';

        $info['submit_field'] = '%1$s %2$s';
    } else {
        $info['comment_field'] = '

    <div class="contact-form">
        <div class="row">
            <div class="col-xl-12 form-group">
                <div class="tx-input-field input-field">
                    <label class="pf-form-1-label" for="message">' . esc_attr__( 'message', 'mojito' ) . '</label>
                    <textarea class="pf-form-1-input" placeholder="' . esc_attr__( 'Write your message here...', 'mojito' ) . '"></textarea>
                </div>
            </div>';
        $info['submit_field'] = '%1$s %2$s</div>
        </div>
        ';
    }

    $form_wrapper = 'logged-in';
    if ( !is_user_logged_in() ) {
        $form_wrapper = 'not-logged';
    }

    $info['submit_button'] = '
    <div class="col-xl-12 submit-button ' . esc_attr( $form_wrapper ) . '">
        <div class="input-field tx-button-wrapper m-0">
            <button type="submit" aria-label="name">
                ' . esc_html__( 'send message', 'mojito' ) . '
            </button>
        </div>
    </div>';

    // check if number of comments is zero
    $comments_number = get_comments_number();

    if( $comments_number == 0 ) {
        $title_class = "mt-0";
    } else {
        $title_class = "mt-0";
    }


    $info['title_reply_before'] = '<h3 class="fti-heading-3 blog-details-form-title '.esc_attr($title_class).'">';
    $info['title_reply_after'] = '</h3>';
    $info['comment_notes_before'] = '';

    return $info;
}

// comment view function

if ( !function_exists( 'mojito_comment' ) ) {
    function mojito_comment( $comment, $args, $depth ) {
        $GLOBAL['comment'] = $comment;
        extract( $args, EXTR_SKIP );
        $args['reply_text'] = '<i class="fas fa-comment"></i>'  . esc_html__( ' Reply', 'mojito' ) . '';
        $replayClass = 'comment-depth-' . esc_attr( $depth );
        ?>
        <li id="comment-<?php comment_ID();?>">
            <div class="log-comment-item d-flex flex-wrap position-relative pera-content tx-comment-box">

                <?php if( get_avatar($comment, 78, null, null, ['class' => []]) == true ) : ?>
                <div class="log-comment-img">
                    <?php print get_avatar( $comment, 78, null, null, ['class' => ['blog-details-comment-card-img']] );?>
                </div>
                <?php endif; ?>

                <div class="log-comment-text">
                    <div class="author-name-date">
                        <span class="cm-name"><?php print get_comment_author_link();?></span>
                        <span class="cm-date"><?php comment_time( get_option( 'date_format' ) );?></span>
                    </div>
                    <?php comment_text();?>
                </div>
                <div class="log-like-reply position-absolute text-capitalize">
                    <?php comment_reply_link( array_merge( $args, ['depth' => $depth, 'max_depth' => $args['max_depth']] ) );?>
                </div>
            </div>

        </li>
		<?php
}
}