<?php
// header logos
function mojito_header_logo() {
    ?>
    <?php
        $mojito_site_logo = cs_get_option( 'mojito_logo', get_template_directory_uri() . '/assets/img/logo/logo.webp');
        if(isset($mojito_site_logo['url'])) {
            $logo_url = $mojito_site_logo['url'];
        } else {
            $logo_url = get_template_directory_uri() . '/assets/img/logo/logo.webp';
        }
            if ( has_custom_logo() ) {
                the_custom_logo();
            } else {
                ?>
                <a class="tx-logo pf-header-1-logo" href="<?php print esc_url( home_url( '/' ) );?>">
                    <img src="<?php echo esc_url($logo_url); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text($logo_url); } ?>" />
                </a>
                <?php
            }
        ?>
    <?php
}


// side info logo
function mojito_side_info_logo() {
    $tx_sideInfo_logo = cs_get_option( 'tx_sideInfo_logo', get_template_directory_uri() . '/assets/img/logo/logo.webp');
    if(isset($tx_sideInfo_logo['url'])) {
        $logo_url = $tx_sideInfo_logo['url'];
    } else {
        $logo_url = get_template_directory_uri() . '/assets/img/logo/logo.webp';
    }

    ?>
    <a class="mobile-menu-logo tx-logo" aria-label="logo" href="<?php print esc_url( home_url( '/' ) );?>">
        <img src="<?php print esc_url( $logo_url );?>" alt="<?php if(function_exists('logo_url')) { echo mojito_img_alt_text($logo_url); } ?>" />
    </a>


<?php }