<?php

/**
 * Default Header Style
 */
function mojito_default_header() {
    if ( has_nav_menu( 'main-menu' ) ) {
        $no_menu_class = '';
    } else {
        $no_menu_class = 'no-menu ';
    }

    ?>
	<header class="mt-header-section header_style_one tx-header tx-DefaultHeader <?php echo esc_attr($no_menu_class); ?>">
		<div class="mt-header-content d-flex justify-content-between align-items-center" data-background="<?php echo esc_url(get_template_directory_uri(  )); ?>/assets/img/shape/header-bg.jpg">
			<div class="brand-logo">
				<?php function_exists( 'mojito_header_logo' ) ? mojito_header_logo() : '';?>
			</div>

			<?php if ( has_nav_menu( 'main-menu' ) ) : ?>
			<nav class="main-navigation clearfix ul-li">
				<?php function_exists( 'mojito_header_menu' ) ? mojito_header_menu( 'main-menu' ) : null;?>
			</nav>
			<div class="header-cta-mobile-btn d-flex align-items-center">
				<button class="mobile-menu-btn mobile_menu_button open_mobile_menu">
					<span></span>
					<span></span>
					<span></span>
				</button>
			</div>
			<?php endif;?>
		</div>
	</header>

	<!-- Mobile Menu -->
	<div class="mobile_menu lenis lenis-smooth position-relative">
		<div class="mobile_menu_wrap">
			<div class="mobile_menu_overlay open_mobile_menu"></div>
			<div class="mobile_menu_content">
				<div class="mobile_menu_close open_mobile_menu">
					<i class="fas fa-times"></i>
				</div>
				<div class="m-brand-logo">
					<?php function_exists( 'mojito_header_logo' ) ? mojito_header_logo() : '';?>
				</div>
				<?php if ( has_nav_menu( 'main-menu' ) ) : ?>
				<nav class="mobile-main-navigation  clearfix ul-li">
					<?php function_exists( 'mojito_header_menu' ) ? mojito_header_menu( 'main-menu' ) : null;?>
				</nav>
				<?php endif;?>
			</div>
		</div>
	</div>
	<?php
}
