<?php

/**
 * [mojito_breadcrumb description]
 * @return [type] [description]
 */
function mojito_breadcrumb() {

    $wpbreadcrumb_class = '';
    $breadcrumb_show = 1;

    $id = get_the_ID();

    if ( is_front_page() && is_home() ) {
        $title = get_the_title();
        $wpbreadcrumb_class = 'tx-front-page';
    } elseif ( is_front_page() ) {
        $title = get_the_title();
        $breadcrumb_show = 0;

    } elseif ( is_home() ) {
        if ( get_option( 'page_for_posts' ) ) {
            $id = get_option( 'page_for_posts' );
            $title = get_the_title( get_option( 'page_for_posts' ) );
        }
    } elseif ( is_single() && 'post' == get_post_type() ) {
        $title = get_the_title();
    } elseif ( is_search() ) {
        $title = esc_html__( 'Search Results for : ', 'mojito' ) . get_search_query();
    } elseif ( is_404() ) {
        $title = esc_html__( 'Page not Found', 'mojito' );
    } elseif ( function_exists( 'is_woocommerce' ) && is_shop() ) {
        $title = get_the_title( get_option( 'woocommerce_shop_page_id' ) );
    } elseif ( function_exists( 'is_woocommerce' ) && is_product() ) {
        $title = __( 'Product Details', 'mojito' );
    } elseif ( function_exists( 'is_woocommerce' ) && is_product_tag() ) {
        $title = get_the_archive_title();
    } elseif ( function_exists( 'is_woocommerce' ) && is_product_category() ) {
        $title = get_the_archive_title();
    } elseif ( is_archive() ) {
        $title = get_the_archive_title();
    } else {
        $title = get_the_title();
    }

    // from page meta
    if ( get_option( 'page_for_posts' ) ) {
        $page_for_posts = get_queried_object_id();
        $page_for_posts_meta = get_post_meta( $page_for_posts, 'tx_page_meta', true ) ? get_post_meta( $page_for_posts, 'tx_page_meta', true ) : [];
    } else {
        $page_meta = get_post_meta( $id, 'tx_page_meta', true ) ? get_post_meta( $id, 'tx_page_meta', true ) : [];
    }

    if ( get_option( 'page_for_posts' ) ) {
        $enable_page_preadcrumb = array_key_exists( 'enable_page_preadcrumb', $page_for_posts_meta ) ? $page_for_posts_meta['enable_page_preadcrumb'] : true;
    } else {
        $enable_page_preadcrumb = array_key_exists( 'enable_page_preadcrumb', $page_meta ) ? $page_meta['enable_page_preadcrumb'] : true;
    }

    if ( get_option( 'page_for_posts' ) ) {
        $enable_bg_image = array_key_exists( 'enable_bg_image', $page_for_posts_meta ) ? $page_for_posts_meta['enable_bg_image'] : true;
    } else {
        $enable_bg_image = array_key_exists( 'enable_bg_image', $page_meta ) ? $page_meta['enable_bg_image'] : true;
    }

    if ( $enable_page_preadcrumb == true && $breadcrumb_show == 1 ) {

        // from page meta
        if ( get_option( 'page_for_posts' ) ) {
            $bg_img_from_page = array_key_exists( 'bg_img_from_page', $page_for_posts_meta ) ? $page_for_posts_meta['bg_img_from_page'] : '';
            $enable_custom_title = array_key_exists( 'enable_custom_title', $page_for_posts_meta ) ? $page_for_posts_meta['enable_custom_title'] : false;
            $page_custom_title = array_key_exists( 'page_custom_title', $page_for_posts_meta ) ? $page_for_posts_meta['page_custom_title'] : '';
            $enable_breadcrumb_short_description = array_key_exists( 'enable_breadcrumb_short_description', $page_for_posts_meta ) ? $page_for_posts_meta['enable_breadcrumb_short_description'] : true;
            $breadcrumb_short_description = array_key_exists( 'breadcrumb_short_description', $page_for_posts_meta ) ? $page_for_posts_meta['breadcrumb_short_description'] : '';
            $enable_breadcrumb_button = array_key_exists( 'enable_breadcrumb_button', $page_for_posts_meta ) ? $page_for_posts_meta['enable_breadcrumb_button'] : false;
            $breadcrumb_button_text = array_key_exists( 'breadcrumb_button_text', $page_for_posts_meta ) ? $page_for_posts_meta['breadcrumb_button_text'] : '';
            $breadcrumb_button_link = array_key_exists( 'breadcrumb_button_link', $page_for_posts_meta ) ? $page_for_posts_meta['breadcrumb_button_link'] : '';
            $breadcrumb_button_icon = array_key_exists( 'breadcrumb_button_icon', $page_for_posts_meta ) ? $page_for_posts_meta['breadcrumb_button_icon'] : '';
        } else {
            $bg_img_from_page = array_key_exists( 'bg_img_from_page', $page_meta ) ? $page_meta['bg_img_from_page'] : '';
            $enable_custom_title = array_key_exists( 'enable_custom_title', $page_meta ) ? $page_meta['enable_custom_title'] : false;
            $page_custom_title = array_key_exists( 'page_custom_title', $page_meta ) ? $page_meta['page_custom_title'] : '';
            $enable_breadcrumb_short_description = array_key_exists( 'enable_breadcrumb_short_description', $page_meta ) ? $page_meta['enable_breadcrumb_short_description'] : true;
            $breadcrumb_short_description = array_key_exists( 'breadcrumb_short_description', $page_meta ) ? $page_meta['breadcrumb_short_description'] : '';
            $enable_breadcrumb_button = array_key_exists( 'enable_breadcrumb_button', $page_meta ) ? $page_meta['enable_breadcrumb_button'] : false;
            $breadcrumb_button_text = array_key_exists( 'breadcrumb_button_text', $page_meta ) ? $page_meta['breadcrumb_button_text'] : '';
            $breadcrumb_button_link = array_key_exists( 'breadcrumb_button_link', $page_meta ) ? $page_meta['breadcrumb_button_link'] : '';
            $breadcrumb_button_icon = array_key_exists( 'breadcrumb_button_icon', $page_meta ) ? $page_meta['breadcrumb_button_icon'] : '';
        }

        // from theme option
        $breadcrumb_bg = cs_get_option( 'breadcrumb_bg_img' );
        $enable_breadcrumb_short_description_customizer = cs_get_option( 'enable_breadcrumb_short_description', true );
        $breadcrumb_short_description_customizer = cs_get_option( 'breadcrumb_short_description', __( 'Our company has been honored with awards for excellence, innovation, and outstanding business achievements.', 'mojito' ) );
        $enable_breadcrumb_button_customizer = cs_get_option( 'enable_breadcrumb_button', false );
        $breadcrumb_button_text_customizer = cs_get_option( 'breadcrumb_button_text', __( 'Get Started', 'mojito' ) );
        $breadcrumb_button_link_customizer = cs_get_option( 'breadcrumb_button_link', '#' );
        $breadcrumb_button_icon_customizer = cs_get_option( 'breadcrumb_button_icon' );
        $bg_img = !empty( $breadcrumb_bg ) ? $breadcrumb_bg['url'] : '';

        if ( $enable_bg_image == false ) {
            $bg_img = $bg_img;
        } else {
            $bg_img = !empty( $bg_img_from_page['url'] ) ? $bg_img_from_page['url'] : $bg_img;
        }

        $shop_details_breadcrumb = is_single() && 'product' == get_post_type() ? ' no-breadcrumb-ttile' : '';
        $bg_url = !empty( $bg_img ) ? $bg_img : "";

        $title = $enable_custom_title == true ? $page_custom_title : $title;
        $breadcrumb_short_description = $enable_breadcrumb_short_description == true ? $breadcrumb_short_description : $breadcrumb_short_description_customizer;
        $breadcrumb_short_description = $breadcrumb_short_description == '' ? $breadcrumb_short_description_customizer : $breadcrumb_short_description;
        $enable_breadcrumb_button = $enable_breadcrumb_button == true ? $enable_breadcrumb_button : $enable_breadcrumb_button_customizer;
        $breadcrumb_button_text = $enable_breadcrumb_button == true ? $breadcrumb_button_text : $breadcrumb_button_text_customizer;
        $breadcrumb_button_text = $breadcrumb_button_text == '' ? $breadcrumb_button_text_customizer : $breadcrumb_button_text;
        $breadcrumb_button_link = $enable_breadcrumb_button == true ? $breadcrumb_button_link : $breadcrumb_button_link_customizer;
        $breadcrumb_button_link = $breadcrumb_button_link == '' ? $breadcrumb_button_link_customizer : $breadcrumb_button_link;
        $breadcrumb_button_icon = $enable_breadcrumb_button == true ? $breadcrumb_button_icon : $breadcrumb_button_icon_customizer;
        $breadcrumb_button_icon = $breadcrumb_button_icon == '' ? $breadcrumb_button_icon_customizer : $breadcrumb_button_icon;

        // check if front page
        if ( is_front_page() ) {
            $title = __('Blog', 'mojito');
        }

        $enable_breadcrumb = cs_get_option( 'enable_breadcrumb', true );
        $enable_breadcrumb_list = cs_get_option( 'enable_breadcrumb_list', true );
        $breadcrumb_shape_img_1 = cs_get_option( 'breadcrumb_shape_img_1' , get_template_directory_uri() . '/assets/img/breadcrumb/breadcrumb-shape.webp');

        if( $enable_breadcrumb == true && !is_404() && 'post' !== get_post_type() && 'projects' !== get_post_type() ) :
        ?>
        <div class="breadcrumb-area tx-breadcrumb mt-breadcrumb-section position-relative <?php echo esc_attr( $wpbreadcrumb_class . $shop_details_breadcrumb ); ?>">
            <?php if(!empty( $bg_img )) : ?>
            <div class="bread-bg position-absolute">
            <img src="<?php echo esc_url($bg_img); ?>"
            alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $bg_img ); } ?>" class="breadcrumb-shape">
            </div>
            <?php endif; ?>
            <div class="container mt-container-1">
                <div class="mt-breadcrumb-content headline pera-content position-relative">
                    <div class="mt-breadcrumb-text">
                        <h1 class="breadcrumb_title"><?php echo wp_kses_post($title); ?></h1>
                        <?php if( $enable_breadcrumb_short_description == true && MOJITO_WOOCOMMERCE_ACTIVED && 'product' !== get_post_type() && !is_checkout() && !is_cart() ) : ?>
                        <p><?php echo esc_html($breadcrumb_short_description); ?></p>
                        <?php endif; ?>

                        <?php if( $enable_breadcrumb_button == true ) : ?>
                        <a class="bread_btn text-uppercase" href="<?php echo esc_url($breadcrumb_button_link); ?>">
                            <?php echo esc_html($breadcrumb_button_text); ?>
                            <?php if(!empty( $breadcrumb_button_icon )) : ?>
                            <i class="<?php echo esc_attr($breadcrumb_button_icon) ?>"></i>
                            <?php endif; ?>
                        </a>
                        <?php endif; ?>
                    </div>
                    <?php if( $enable_breadcrumb_list == true ) : ?>
                    <div class="mt-breadcrumb-list ul-li">
                        <?php mojito_breadcrumb_callback(); ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
        endif;

        if( $enable_breadcrumb == true && 'post' == get_post_type() ) :
        $id = get_the_ID();
        if(has_post_thumbnail()) {
        $bg_img = get_the_post_thumbnail_url( $id, 'full' );
        } else {
            $bg_img = $bg_img;
        }

        // blog details shape img
        $blog_details_shape = cs_get_option( 'blog_details_shape');

        while ( have_posts() ):
        the_post();
            $enable_author_meta = cs_get_option( 'enable_author_meta', true );
            $enable_default_date = cs_get_option( 'enable_default_date', true );
            $enable_comment_meta = cs_get_option( 'enable_comment_meta', true );
            $post_author_name = get_the_author_meta('display_name');
            $post_thumbnail = get_the_post_thumbnail_url( $id, 'full' );
        endwhile;

         if ( has_post_thumbnail() ) {
            $has_bg_color = ' has_bg_color ';
        } else {
            $has_bg_color = ' hasNot_bg_color';
        }
        ?>
        <div class="breadcrumb-area tx-breadcrumb position-relative <?php echo esc_attr( $wpbreadcrumb_class . $shop_details_breadcrumb . $has_bg_color ); ?>">
            <div class="mt-blog-details-hero position-relative">
                <div class="thumb-bg position-absolute">
                    <?php if(!empty( $blog_details_shape['url'] )) : ?>
                    <img src="<?php echo esc_url($blog_details_shape['url']); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $blog_details_shape['url'] ); } ?>">
                    <?php endif; ?>
                </div>

                <div class="container mt-container-1">
                    <div class="mt-blog-thumb-content">
                        <div class="back_btn">
                            <a href="<?php echo esc_url(home_url()); ?>">
                                <i class="fa-solid fa-chevron-left"></i>
                                <?php echo esc_html__('Back to Blog Page', 'mojito'); ?>
                            </a>
                        </div>
                        <div class="mt-blog-thumb mt-50 headline text-center">
                            <div class="blog-meta">
                                <?php if( $enable_author_meta == true ) : ?>
                                <a href="<?php the_permalink(); ?>"><i class="fa-solid fa-user"></i>
                                    <?php echo esc_html($post_author_name); ?>
                                </a>
                                <?php endif; ?>

                                <?php if( $enable_comment_meta == true ) : ?>
                                <a href="<?php the_permalink(); ?>"><i class="fa-solid fa-comments"></i>
                                <?php
                                    $comment_count = get_comments_number();
                                    $comment_text = ($comment_count === '1') ? ' Comment ' : ' Comments ';
                                    echo esc_html($comment_text, 'logistify') . '(' . $comment_count . ')';
                                ?>
                                </a>
                                <?php endif; ?>

                                <?php if( $enable_default_date == true ) : ?>
                                <a href="<?php the_permalink(); ?>"><i class="fa-solid fa-calendar-days"></i>
                                    <?php echo esc_html( get_the_date( get_option( 'date_format' ), $id ) ); ?>
                                </a>
                                <?php endif; ?>
                            </div>

                            <h2>
                                <?php echo wp_kses_post($title); ?>
                            </h2>

                            <?php if ( has_post_thumbnail() ): ?>
                            <div class="blog-thumb mt-70">
                                <img src="<?php echo esc_url($bg_img); ?>"
                                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $bg_img ); } ?>" class="breadcrumb-shape">
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        endif;
    }
}
add_action( 'mojito_before_main_content', 'mojito_breadcrumb' );

function mojito_breadcrumb_callback() {
    $args = [
        'show_browse'   => false,
        'post_taxonomy' => ['product' => 'product_cat'],
    ];
    $breadcrumb = new MojitoBreadcrumbClass( $args );

    return $breadcrumb->trail();
}
