<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-layouts
 *
 * @package mojito
 */

$preloader_enable = cs_get_option( 'preloader_enable', true );
$enable_scroll_up = cs_get_option( 'enable_scroll_up', true );
?>

<!doctype html>
<html <?php if(function_exists('language_attributes')) {language_attributes();} ?> <?php if(function_exists('mojito_enable_rtl')) { print mojito_enable_rtl();} ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' );?>">
    <?php if ( is_singular() && pings_open( get_queried_object() ) ): ?>
    <?php endif;?>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head();?>
</head>

<body <?php body_class();?>>
<?php wp_body_open();?>

<div class="page-wrapper">

    <div class="offcanvas-overlay"></div>

    <!-- preloader start -->
    <?php if( $preloader_enable == true ) : ?>
    <div id="preloader">
  		<div class="preloader-wrap">
  			<div class="loading headline">
  				<h3 class="loading-text loader_text loader_text_ani">MOJITO</h3>
  			</div>
  		</div>
  	</div>
    <?php endif; ?>
    <!-- preloader end -->

    <?php if( $enable_scroll_up == true ) : ?>
    <div class="up">
  		<a href="#" class="scrollup text-center"><i class="fa-solid fa-arrow-up"></i></a>
  	</div>
    <?php endif; ?>

    <!-- header start -->
    <?php do_action( 'mojito_header_style' ); ?>
    <!-- header end -->

    <!-- wrapper-box start -->
    <?php do_action( 'mojito_before_main_content' ); ?>