<?php

// DEFINE CONSTANTS
define( 'MOJITO_THEME_DIR', get_template_directory() );
define( 'MOJITO_THEME_URI', get_template_directory_uri() );
define( 'MOJITO_THEME_CSS_DIR', MOJITO_THEME_URI . '/assets/css/' );
define( 'MOJITO_THEME_JS_DIR', MOJITO_THEME_URI . '/assets/js/' );
define( 'MOJITO_THEME_INC', MOJITO_THEME_DIR . '/inc/' );
define( 'MOJITO_CORE_PLUG_DIR', plugins_url( 'mojito-core/assets/' ) );
define( 'MOJITO_CORE', in_array( 'mojito-core/mojito-core.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) );

// INCLUDE CS FRAMEWORK FILE
require MOJITO_THEME_INC . 'csf-functions.php';

if ( !defined( 'MOJITO_WOOCOMMERCE_ACTIVED' ) ) {
    define( 'MOJITO_WOOCOMMERCE_ACTIVED', in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) );
}

if ( home_url() == "https://themexriver.com/wp/mojito" OR home_url() == 'http://localhost:10010' ) {
    define( 'VERSION', time() );
} else {
    define( 'VERSION', wp_get_theme()->get( 'Version' ) );
}

if ( MOJITO_WOOCOMMERCE_ACTIVED ) {
    /**
     * Remove Action Hook
     */
    function mojito_woo_theme_init(){
        $mojito_exlude_hooks = require MOJITO_THEME_INC . 'woocommerce/woo-actions.php';
        foreach( $mojito_exlude_hooks as $k => $v )
        {
            foreach( $v as $value )
            remove_action( $k, $value[0], $value[1] );
        }

    }
    add_action( 'init', 'mojito_woo_theme_init');
}

// INCLUDE MOJITO AFTER SETUP
require MOJITO_THEME_INC . 'mojito-after-setup.php';

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function mojito_content_width() {
    // This variable is intended to be overruled from themes.
    // Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
    $GLOBALS['content_width'] = apply_filters( 'mojito_content_width', 640 );
}
add_action( 'after_setup_theme', 'mojito_content_width', 0 );

// INCLUDE MOJITO REGISTER WIDGETS
require MOJITO_THEME_INC . 'mojito-register-widgets.php';

// INCLUDE MOJITO ENQUEUE SCRIPTS
require MOJITO_THEME_INC . 'mojito-enqueue-scripts.php';

// INCLUDE CUSTOM HEADER
require MOJITO_THEME_INC . 'custom-header.php';

// INCLUDE CUSTOM FUNCTIONS FILE
require MOJITO_THEME_INC . 'mojito-functions.php';

// INCLUDE CUSTOM CSS
require MOJITO_THEME_INC . 'mojito-custom-css.php';

// INCLUDE DEFAULT COMMENT
require MOJITO_THEME_INC . 'mojito-comment.php';

// INCLUDE LOGO FILE
require MOJITO_THEME_INC . 'layouts/mojito-logos.php';

// INCLUDE MENU FILE
require MOJITO_THEME_INC . 'layouts/mojito-menus.php';

// INCLUDE DEFAULT BREADCRUMB
require MOJITO_THEME_INC . 'layouts/mojito-breadcrumb.php';

// INCLUDE ALL ACTION FILE
require MOJITO_THEME_INC . 'layouts/mojito-actions.php';

// INCLUDE DEFAULT HEADER
require MOJITO_THEME_INC . 'layouts/mojito-default-header.php';

// INCLUDE FOOTER FILE
require MOJITO_THEME_INC . 'layouts/mojito-default-footer.php';

// INCLUDE SEARCH WIDGET FILE
require MOJITO_THEME_INC . 'mojito-search-widget.php';

// LOAD JETPACK COMPATIBILITY FILE
if ( defined( 'JETPACK__VERSION' ) ) {
    require MOJITO_THEME_INC . 'jetpack.php';
}

// ALL CLASS FILE
include_once MOJITO_THEME_INC . 'classes/class-mojito-helper.php';
require_once MOJITO_THEME_INC . 'classes/class-breadcrumb.php';
require_once MOJITO_THEME_INC . 'classes/class-navwalker.php';
require_once MOJITO_THEME_INC . 'classes/class-tgm-plugin-activation.php';
require_once MOJITO_THEME_INC . 'required-plugin.php';