(function ($) {
	"use strict";

	// image background
	function bgImageActive($scope, $) {
		$("[data-background]").each(function () {
			$(this).css(
				"background-image",
				"url(" + $(this).attr("data-background") + ") "
			);
		});
	}

	// data-bg-color
	function bgColorActive($scope, $) {
		$("[data-bg-color]").each(function () {
			$(this).css("background-color", $(this).attr("data-bg-color"));
		});
	}

	// data-bg-color
	function tx_brand($scope, $) {
		if ($(".mt-sponsor-slide").length > 0) {
			var mt_sponsor_slide = new Swiper(".mt-sponsor-slide", {
				spaceBetween: 110,
				slidesPerView: 4,
				roundLengths: true,
				loop: true,
				loopAdditionalSlides: 30,
				autoplay: {
					enabled: true,
					delay: 6000,
				},
				speed: 400,
				breakpoints: {
					1600: {
						slidesPerView: 4,
					},
					1200: {
						slidesPerView: 4,
					},
					992: {
						slidesPerView: 4,
					},
					768: {
						slidesPerView: 4,
					},
					576: {
						slidesPerView: 3,
						spaceBetween: 50,
					},
					0: {
						slidesPerView: 2,
					},
				},
			});
		}
	}

	// tx_service_lists
	function tx_service_lists($scope, $) {
		if ($(".mt-portfolio-slider").length) {
			var mt_portfolio_slider = new Swiper(".mt-portfolio-slider", {
				slidesPerView: 4,
				loop: true,
				spaceBetween: 48,
				speed: 1000,
				navigation: {
					nextEl: ".mt-port-next",
					prevEl: ".mt-port-prev",
				},
				breakpoints: {
					1400: {
						slidesPerView: 4,
					},
					1300: {
						slidesPerView: 4,
					},
					1200: {
						slidesPerView: 3,
					},
					992: {
						slidesPerView: 3,
					},
					768: {
						slidesPerView: 2,
					},
					576: {
						slidesPerView: 1,
					},
					480: {
						slidesPerView: 1,
					},
					0: {
						slidesPerView: 1,
					},
				},
			});
		}

		if($('.mt-portfolio-slider-3').length) {
			let mt_portfolio_slider_3 = new Swiper('.mt-portfolio-slider-3', {
				loop: true,
				spaceBetween: 32,
				speed: 500,
				autoplay: {
					delay: 5000,
				},

				navigation: {
					nextEl: ".mt-port-next",
					prevEl: ".mt-port-prev",
				},
				breakpoints: {
					0: {
						slidesPerView: 1,
					},
					576: {
						slidesPerView: 1,
					},
					768: {
						slidesPerView: 2,
					},
					992: {
						slidesPerView: 2,
					},
					1200: {
						slidesPerView: 3,
					},
					1400: {
						slidesPerView: 3,
					},
					1600: {
						slidesPerView: 3,
					},
				},

			});
		}
	}

	// tx_testimonial
	function tx_testimonial($scope, $) {

		$(".mt-testimonial-item").on("click", function () {
			$(".mt-testimonial-item").removeClass("active");
			$(this).addClass("active");
		});

		// services-1
		if ($(".mt-service-slide").length) {
			let slider = new Swiper(".mt-service-slide", {
				loop: true,
				spaceBetween: 20,
				direction: "vertical",
				speed: 500,
				autoplay: {
					delay: 5000,
				},

				navigation: {
					nextEl: ".mt-ser-next",
					prevEl: ".mt-ser-prev",
				},
				breakpoints: {
					0: {
						slidesPerView: 1,
						direction: "horizontal",
					},
					576: {
						slidesPerView: 2,
						direction: "horizontal",
					},
					768: {
						slidesPerView: 2,
					},
					992: {
						slidesPerView: 3,
					},
					1200: {
						slidesPerView: 3,
					},
					1400: {
						slidesPerView: 3,
					},
					1600: {
						slidesPerView: 3,
					},
				},
			});
		}

		let mt_testi_thumb_active = new Swiper('.mt-testi-thumb-active', {
			spaceBetween: 24,
			loop: false,
			speed: 1000,
			slidesPerView: 3,
			breakpoints: {
				320: {
					slidesPerView: 3,
				},
				576: {
					slidesPerView: 3,
				},
				768: {
					slidesPerView: 3,
				},
				992: {
					slidesPerView: 3,
				},
				1200: {
					slidesPerView: 3,
				},
				1400: {
					slidesPerView: 3,
				},
				1600: {
					slidesPerView: 3,
				},

			}
		});
		let mt_testimonial_slide = new Swiper('.mt-testimonial-slide', {
			loop: true,
			spaceBetween: 0,
			rtl: false,
			slidesPerView: 1,
			thumbs: {
				swiper: mt_testi_thumb_active,
			},
		});


		let mt_testimonial_img_thumb = new Swiper('.mt-testimonial-img-thumb', {
			spaceBetween: 0,
			loop: true,
			speed: 500,
			allowTouchMove: false,
			centeredSlides: true,
			slidesPerView: 3,
			navigation: {
				nextEl: ".mt-test-next-4",
				prevEl: ".mt-test-prev-4",
			},
			breakpoints: {
				0: {
					slidesPerView: 1,
				},
				320: {
					slidesPerView: 1,
				},
				576: {
					slidesPerView: 1,
				},
				768: {
					slidesPerView: 3,
				},
				992: {
					slidesPerView: 3,
				},
				1200: {
					slidesPerView: 3,
				},
				1400: {
					slidesPerView: 3,
				},
				1600: {
					slidesPerView: 3,
				},

			}
		});

		let mt_testimonial_slide_4 = new Swiper('.mt-testimonial-slide-4', {
			loop: true,
			slidesPerView: 1,
			speed: 500,
			effect: 'fade',
			fadeEffect: {
				crossFade: true
			},
			allowTouchMove: false,
			navigation: {
				nextEl: ".mt-test-next-4",
				prevEl: ".mt-test-prev-4",
			},
			thumbs: {
				swiper: mt_testimonial_img_thumb,
			},
		});
	}

	// tx_team_section
	function tx_team_section($scope, $) {
		if ($(".mt-team-slider").length) {
			var mt_team_slider = new Swiper(".mt-team-slider", {
				slidesPerView: 1,
				loop: true,
				spaceBetween: 0,
				speed: 1000,
				effect: 'fade',
				fadeEffect: {
					crossFade: true
				},
				navigation: {
					nextEl: ".mt-team-next",
					prevEl: ".mt-team-prev",
				},
			});
		};
	}

	// tx_post_grid
	function tx_post_grid($scope, $) {
		if($('.mt-blog-slider').length) {
			let mt_blog_slider = new Swiper('.mt-blog-slider', {
				loop: true,
				spaceBetween: 25,
				speed: 500,
				pagination: {
					el: ".blog-pagination",
					clickable: true,
				},
				breakpoints: {
					0: {
						slidesPerView: 1,
					},
					576: {
						slidesPerView: 2,
					},
					768: {
						slidesPerView: 2,
					},
					992: {
						slidesPerView: 3,
					},
					1200: {
						slidesPerView: 3,
					},
					1400: {
						slidesPerView: 3,
					},
					1600: {
						slidesPerView: 3,
					},
				},

			});
		}
	}

	$(window).on("elementor/frontend/init", function () {
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tx_hero_section.default",
			function ($scope, $) {
				bgImageActive($scope, $);
			}
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tx_about.default",
			function ($scope, $) {
				bgImageActive($scope, $);
			}
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tx_count_box.default",
			function ($scope, $) {
				bgImageActive($scope, $);
			}
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tx_cta.default",
			function ($scope, $) {
				bgImageActive($scope, $);
			}
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tx_brand.default",
			function ($scope, $) {
				tx_brand($scope, $);
			}
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tx_service_lists.default",
			function ($scope, $) {
				tx_service_lists($scope, $);
			}
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tx_testimonial.default",
			function ($scope, $) {
				tx_testimonial($scope, $);
			}
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tx_team_section.default",
			function ($scope, $) {
				tx_team_section($scope, $);
			}
		);
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tx_post_grid.default",
			function ($scope, $) {
				tx_post_grid($scope, $);
			}
		);
	});
})(jQuery);
