<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package mojito
 */

get_header();

$mojito_error_image = cs_get_option( 'tx_error_image', get_template_directory_uri() . '/assets/img/shape/404.webp' );
if(isset($mojito_site_logo['url'])) {
	$image_url = $mojito_error_image['url'];
} else {
	$image_url = get_template_directory_uri() . '/assets/img/shape/404.webp';
}
$tx_error_title = cs_get_option('tx_error_title', __('Oops! <span>404 Error!s</span>', 'mojito'));
$tx_error_text = cs_get_option('tx_error_title', __('We can\'t find the page that you\'re looking for. Can\'t find what you need? Take a moment and search below!', 'mojito'));
$mojito_error_link_text = cs_get_option('tx_error_link_text', __('Back To Home Page', 'mojito'));

?>

<section class="mt-not-found-section">
	<div class="container mt-container-1">
		<div class="mt-not-found-content d-flex align-items-end">
			<?php if(!empty( $image_url )) : ?>
			<div class="not-found-img">
				<img src="<?php echo esc_url($image_url); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $image_url ); } ?>">
			</div>
			<?php endif; ?>
			<div class="not-found-text headline pera-content">
				<?php if(!empty( $tx_error_title )) : ?>
				<h3>
					<?php print wp_kses($tx_error_title, true);?>
				</h3>
				<?php endif; ?>

				<?php if(!empty( $tx_error_text )) : ?>
				<p><?php print esc_html($tx_error_text);?></p>
				<?php endif; ?>

				<?php if(!empty( $mojito_error_link_text )) : ?>
				<div class="mt-btn-2 text-uppercase">
					<a href="<?php echo esc_url(home_url()); ?>">
						<span><?php print esc_html($mojito_error_link_text);?></span>
						<i class="fas fa-arrow-right"></i>
					</a>
				</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section

<?php
get_footer();
