<?php
/*
 * Theme Metabox
 * @package mojitotools
 * @since 1.0.0
 * */

if ( !defined( 'ABSPATH' ) ) {
    exit(); // exit if access directly
}

if ( class_exists( 'CSF' ) ) {

    $prefix = 'mojito';

    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $page_metabox = 'tx_page_meta';

    CSF::createMetabox( $page_metabox, [
        'title'     => 'Page Options',
        'post_type' => ['page', 'projects', 'services', 'teams'],
    ] );

    // Header Section
    CSF::createSection( $page_metabox, [
        'title'  => 'Header',
        'fields' => [
            [
                'type'    => 'subheading',
                'content' => esc_html__( 'HEADER OPTIONS', 'mojito-core' ),
            ],

            [
                'id'       => 'meta_header_type',
                'type'     => 'switcher',
                'title'    => __( 'Enable Header From Page?', 'mojitoplugin' ),
                'text_on'  => __( 'Yes', 'mojitoplugin' ),
                'text_off' => __( 'No', 'mojitoplugin' ),
                'default'  => false,
            ],
            [
                'id'         => 'meta_header_style',
                'type'       => 'select',
                'title'      => __( 'Select Header Style', 'mojitoplugin' ),
                'options'    => Mojito_Core_Helper::get_header_types(),
                'dependency' => ['meta_header_type', '==', 'true'],
            ],
            [
                'id'       => 'page_header_disable',
                'type'     => 'switcher',
                'title'    => __( 'DIsable This page Header?', 'mojitoplugin' ),
                'text_on'  => __( 'Yes', 'mojitoplugin' ),
                'text_off' => __( 'No', 'mojitoplugin' ),
                'default'  => false,
            ],
        ],
    ] );

    // Breadcrumb Section
    CSF::createSection( $page_metabox, [
        'title'  => 'Page Breadcrumb',
        'fields' => [
            [
                'type'    => 'subheading',
                'content' => esc_html__( 'BREADCRUMB OPTIONS', 'mojito-core' ),
            ],
            [
                'id'       => 'enable_page_preadcrumb',
                'type'     => 'switcher',
                'title'    => __( 'Enable Breadcrumb?', 'mojitoplugin' ),
                'text_on'  => __( 'Yes', 'mojitoplugin' ),
                'text_off' => __( 'No', 'mojitoplugin' ),
                'default'  => true,
            ],
            [
                'id'         => 'hide_bg_img',
                'type'       => 'switcher',
                'title'      => __( 'Enable image from page?', 'mojitoplugin' ),
                'text_on'    => __( 'Yes', 'mojitoplugin' ),
                'text_off'   => __( 'No', 'mojitoplugin' ),
                'default'    => false,
                'dependency' => ['enable_page_preadcrumb', '==', 'true'],
            ],
            [
                'id'         => 'bg_img_from_page',
                'type'       => 'media',
                'title'      => esc_html__( 'Page Breadcrumb Background Image', 'mojito-core' ),
                'dependency' => ['enable_page_preadcrumb', '==', 'true'],
                'dependency' => [
                    ['enable_page_preadcrumb', '==', 'true'],
                    ['hide_bg_img', '==', 'true'],
                ],

            ],
            // enable_custom_title
            [
                'id'         => 'enable_custom_title',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Custom Title', 'mojito-core' ),
                'default'    => false,
                'text_on'    => __( 'Yes', 'mojitoplugin' ),
                'text_off'   => __( 'No', 'mojitoplugin' ),
                'dependency' => ['enable_page_preadcrumb', '==', 'true'],

            ],

            [
                'id'         => 'page_custom_title',
                'type'       => 'text',
                'title'      => esc_html__( 'Page Custom Title', 'mojito-core' ),
                'dependency' => ['enable_custom_title', '==', 'true'],
            ],

            // enable_breadcrumb_short_desc
            [
                'id'         => 'enable_breadcrumb_short_description',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Breadcrumb Short Description', 'mojito-core' ),
                'default'    => true,
                'text_on'    => __( 'Yes', 'mojitoplugin' ),
                'text_off'   => __( 'No', 'mojitoplugin' ),
                'dependency' => ['enable_page_preadcrumb', '==', 'true'],
            ],

            // short description
            [
                'id'         => 'breadcrumb_short_description',
                'type'       => 'textarea',
                'title'      => esc_html__( 'Breadcrumb Short Description', 'mojito-core' ),
                'default'    => 'Our company has been honored with awards for excellence, innovation, and outstanding business achievements.',
                'dependency' => ['enable_breadcrumb_short_description', '==', 'true'],
            ],

            // enable_breadcrumb_button
            [
                'id'         => 'enable_breadcrumb_button',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Breadcrumb Button', 'mojito-core' ),
                'default'    => false,
                'text_on'    => __( 'Yes', 'mojitoplugin' ),
                'text_off'   => __( 'No', 'mojitoplugin' ),
                'dependency' => ['enable_page_preadcrumb', '==', 'true'],
            ],

            // button text
            [
                'id'         => 'breadcrumb_button_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Breadcrumb Button Text', 'mojito-core' ),
                'default'    => 'Get Started',
                'dependency' => ['enable_breadcrumb_button', '==', 'true'],
            ],

            // button link
            [
                'id'         => 'breadcrumb_button_link',
                'type'       => 'text',
                'title'      => esc_html__( 'Breadcrumb Button Link', 'mojito-core' ),
                'default'    => '#',
                'dependency' => ['enable_breadcrumb_button', '==', 'true'],
            ],

            // button icon
            [
                'id'         => 'breadcrumb_button_icon',
                'type'       => 'icon',
                'title'      => esc_html__( 'Breadcrumb Button Icon', 'mojito-core' ),
                'dependency' => ['enable_breadcrumb_button', '==', 'true'],
            ],
        ],
    ] );

    // Footer Section
    CSF::createSection( $page_metabox, [
        'title'  => 'Footer',
        'fields' => [
            [
                'type'    => 'subheading',
                'content' => esc_html__( 'FOOTER OPTIONS', 'mojito-core' ),
            ],
            [
                'id'       => 'meta_footer_type',
                'type'     => 'switcher',
                'title'    => __( 'Enable Footer From Page?', 'mojitoplugin' ),
                'text_on'  => __( 'Yes', 'mojitoplugin' ),
                'text_off' => __( 'No', 'mojitoplugin' ),
                'default'  => false,
            ],
            [
                'id'         => 'meta_footer_style',
                'type'       => 'select',
                'title'      => __( 'Select Footer Style', 'mojitoplugin' ),
                'options'    => Mojito_Core_Helper::get_footer_types(),
                'dependency' => ['meta_footer_type', '==', 'true'],
            ],
            [
                'id'       => 'page_footer_disable',
                'type'     => 'switcher',
                'title'    => __( 'DIsable This page Footer?', 'mojitoplugin' ),
                'text_on'  => __( 'Yes', 'mojitoplugin' ),
                'text_off' => __( 'No', 'mojitoplugin' ),
                'default'  => false,
            ],

        ],
    ] );

    // Footer Section
    CSF::createSection( $page_metabox, [
        'title'  => 'Page Settings',
        'fields' => [
            [
                'type'    => 'subheading',
                'content' => esc_html__( 'PAGE SETTINGS', 'mojito-core' ),
            ],

            // page scroll color
            [
                'id'      => 'page_scroll_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Page Scroll Color', 'mojito-core' ),
                'default' => '#2ac8d3',
            ],
        ],
    ] );

    // project info meta

    // project info meta
    CSF::createSection( $page_metabox, [
        'title'  => 'Project Info',
        'fields' => [
            [
                'type'    => 'subheading',
                'content' => esc_html__( 'Project Infos', 'mojito-core' ),
                'desc'    => esc_html__( 'Add project info (Only For Porject Details Page)', 'mojito-core' ),
            ],
            // enable project info?
            [
                'id'       => 'enable_project_info',
                'type'     => 'switcher',
                'title'    => esc_html__( 'Enable Project Info?', 'mojito-core' ),
                'text_on'  => __( 'Yes', 'mojitoplugin' ),
                'text_off' => __( 'No', 'mojitoplugin' ),
                'default'  => false,
            ],
            [
                'id'     => 'project_infos',
                'type'   => 'repeater',
                'title'  => esc_html__( 'Project Infos', 'mojito-core' ),
                'dependency' => ['enable_project_info', '==', 'true'],
                'fields' => [
                    [
                        'id'    => 'project_info_label',
                        'type'  => 'text',
                        'title' => esc_html__( 'Label', 'mojito-core' ),
                    ],
                    [
                        'id'    => 'project_info_text',
                        'type'  => 'text',
                        'title' => esc_html__( 'Info Text', 'mojito-core' ),
                    ],
                ],
            ],
        ],
    ] );

    // post audio meta options
    $post_audio_metabox = 'tx_post_audio_meta';

    CSF::createMetabox( $post_audio_metabox, [
        'title'        => 'Post Options',
        'post_type'    => ['post'],
        'post_formats' => ['audio'],
    ] );

    CSF::createSection( $post_audio_metabox, [
        'fields' => [
            [
                'id'      => 'post_audio_link',
                'type'    => 'text',
                'title'   => __( 'Audio Link', 'mojitoplugin' ),
                'default' => '',
            ],
        ],
    ] );

    // post video meta options
    $post_video_metabox = 'tx_post_video_meta';

    CSF::createMetabox( $post_video_metabox, [
        'title'        => 'Post Options',
        'post_type'    => ['post'],
        'post_formats' => ['video'],
    ] );

    CSF::createSection( $post_video_metabox, [
        'fields' => [
            [
                'id'      => 'post_video_link',
                'type'    => 'text',
                'title'   => __( 'Video Link', 'mojitoplugin' ),
                'default' => '',
            ],
        ],
    ] );

    // post gallery meta options
    $post_gallery_metabox = 'tx_post_gallery_meta';

    CSF::createMetabox( $post_gallery_metabox, [
        'title'        => 'Post Options',
        'post_type'    => ['post'],
        'post_formats' => ['gallery'],
    ] );

    CSF::createSection( $post_gallery_metabox, [
        'fields' => [
            [
                'id'    => 'post_gallery_images',
                'type'  => 'gallery',
                'title' => __( 'Gallery Images', 'mojitoplugin' ),
            ],
        ],
    ] );

    // product meta options
    $product_metabox = 'tx_product_meta';

    CSF::createMetabox( $product_metabox, [
        'title'     => 'Product Options',
        'post_type' => ['product'],
    ] );

    // product badge
    CSF::createSection( $product_metabox, [
        'title'  => 'Product Badge',
        'fields' => [
            [
                'type'    => 'subheading',
                'content' => esc_html__( 'Product Badge', 'mojito-core' ),
            ],
            [
                'id'       => 'enable_product_badge',
                'type'     => 'switcher',
                'title'    => __( 'Product Badge', 'mojitoplugin' ),
                'text_on'  => __( 'Yes', 'mojitoplugin' ),
                'text_off' => __( 'No', 'mojitoplugin' ),
                'default'  => false,
            ],
            [
                'id'         => 'product_badge_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Product Badge Text', 'mojito-core' ),
                'default'    => 'New',
                'dependency' => ['enable_product_badge', '==', 'true'],
            ],
        ],
    ] );

    // product meta options
    $movie_metabox = 'tx_movie_meta';

    CSF::createMetabox( $movie_metabox, [
        'title'     => 'Movie Info',
        'post_type' => ['movies'],
    ] );

    // product badge
    CSF::createSection( $movie_metabox, [
        'title'  => 'Movie Info',
        'fields' => [
            [
                'type'    => 'subheading',
                'content' => esc_html__( 'Movie Info', 'mojito-core' ),
            ],

            // year label
            [
                'id'      => 'movie_year_label',
                'type'    => 'text',
                'title'   => esc_html__( 'Movie Year Label', 'mojito-core' ),
                'default' => 'Year',
            ],

            // relase year
            [
                'id'      => 'movie_release_year',
                'type'    => 'text',
                'title'   => esc_html__( 'Movie Release Year', 'mojito-core' ),
                'default' => '',
            ],

            // country label
            [
                'id'      => 'movie_rating_label',
                'type'    => 'text',
                'title'   => esc_html__( 'Movie Rating Label', 'mojito-core' ),
                'default' => 'Rating',
            ],

            // movie rating
            [
                'id'    => 'movie_rating',
                'type'  => 'text',
                'title' => esc_html__( 'Movie Rating', 'mojito-core' ),
            ],

            // video link
            [
                'id'    => 'movie_video_link',
                'type'  => 'text',
                'title' => esc_html__( 'Movie Video Link', 'mojito-core' ),
            ],
        ],
    ] );

} //endif
