<?php

CSF::createSection( $prefix . '_theme_options', [
    'title'  => esc_html__( 'Breadcrumb Layout', 'mojito-core' ),
    'parent' => 'theme_layout',
    'priority' => 3,
    'fields' => [
        [
            'type'    => 'subheading',
            'content' => '<h3>' . esc_html__( 'Breadcrumb Layout', 'mojito-core' ) . '</h3>',
        ],
        // enable breadcrumb
        [
            'id'      => 'enable_breadcrumb',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Enable Breadcrumb', 'mojito-core' ),
            'default' => true,
        ],
        // breadcrumb_bg_img
        [
            'id'      => 'breadcrumb_bg_img',
            'title'   => esc_html__( 'Breadcrumb Image', 'mojito-core' ),
            'type'    => 'media',
            'desc'    => esc_html__( 'Upload breadcrumb Image', 'mojito-core' ),
            'preview_width' => '500',
            'preview_height' => '300',
        ],
        // enable breadcrumb short description
        [
            'id'      => 'enable_breadcrumb_short_description',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Enable Breadcrumb Short Description', 'mojito-core' ),
            'default' => true,
        ],
        // breadcrumb short description
        [
            'id'      => 'breadcrumb_short_description',
            'type'    => 'textarea',
            'title'   => esc_html__( 'Breadcrumb Short Description', 'mojito-core' ),
            'default' => 'Our company has been honored with awards for excellence, innovation, and outstanding business achievements.',
            'dependency' => [ 'enable_breadcrumb_short_description', '==', 'true' ],
        ],
        // enable breadcrumb button
        [
            'id'      => 'enable_breadcrumb_button',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Enable Breadcrumb Button', 'mojito-core' ),
            'default' => false,
        ],

        // breadcrumb button text
        [
            'id'      => 'breadcrumb_button_text',
            'type'    => 'text',
            'title'   => esc_html__( 'Breadcrumb Button Text', 'mojito-core' ),
            'default' => 'Get Started',
            'dependency' => [ 'enable_breadcrumb_button', '==', 'true' ],
        ],

        // breadcrumb button link
        [
            'id'      => 'breadcrumb_button_link',
            'type'    => 'text',
            'title'   => esc_html__( 'Breadcrumb Button Link', 'mojito-core' ),
            'default' => '#',
            'dependency' => [ 'enable_breadcrumb_button', '==', 'true' ],
        ],

        // breadcrumb button icon
        [
            'id'      => 'breadcrumb_button_icon',
            'type'    => 'icon',
            'title'   => esc_html__( 'Breadcrumb Button Icon', 'mojito-core' ),
            'dependency' => [ 'enable_breadcrumb_button', '==', 'true' ],
        ],

        // enable breadcrumb list
        [
            'id'      => 'enable_breadcrumb_list',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Enable Breadcrumb List', 'mojito-core' ),
            'default' => true,
        ],

        // enable shape 1
        [
            'id'      => 'enable_shape_1',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Enable Shape 1', 'mojito-core' ),
            'default' => false,
        ],

        // breadcrub shape image 1
        [
            'id'      => 'breadcrumb_shape_img_1',
            'title'   => esc_html__( 'Breadcrumb Shape Image 1', 'mojito-core' ),
            'type'    => 'media',
            'desc'    => esc_html__( 'Upload breadcrumb Shape Image 1', 'mojito-core' ),
            'preview_width' => '500',
            'preview_height' => '300',
            'default' => get_template_directory_uri() . '/assets/img/breadcrumb/breadcrumb-shape.webp',
            'dependency' => [ 'enable_shape_1', '==', 'true' ],
        ],

        // breadcrub padding
        [
            'id'          => 'breadcrumb_padding',
            'type'        => 'spacing',
            'title'       => esc_html__( 'Breadcrumb Padding', 'mojito-core' ),
            'output'      => '.tx-breadcrumb',
            'output_mode' => 'padding',
            'units'       => [ 'px', 'em' ],
            'default'     => [
                'top'    => '100px',
                'right'  => '0px',
                'bottom' => '100px',
                'left'   => '0px',
            ],
        ],
    ],
] );