<?php

CSF::createSection( $prefix . '_theme_options', [
    'title'    => esc_html__( '404 Page Layout', 'mojito-core' ),
    'parent'   => 'theme_layout',
    'priority' => 4,
    'fields'   => [
        [
            'type'    => 'subheading',
            'content' => '<h3>' . esc_html__( '404 Page Layout', 'mojito-core' ) . '</h3>',
        ],
        [
            'id'      => 'tx_error_image',
            'type'    => 'media',
            'title'   => esc_html__( 'Error Code Image', 'mojito-core' ),
            'default' => get_template_directory_uri() . '/assets/img/shape/404.webp',
        ],
        // tx_error_title
        [
            'id'      => 'tx_error_title',
            'type'    => 'text',
            'title'   => esc_html__( '404 Title', 'mojito-core' ),
            'default' => esc_html__( 'Oops! 404 Error!', 'mojito-core' ),
        ],
        // tx_error_text
        [
            'id'      => 'tx_error_text',
            'type'    => 'textarea',
            'title'   => esc_html__( '404 Text', 'mojito-core' ),
            'default' => esc_html__( 'We can\'t find the page that you\'re looking for. Can\'t find what you need? Take a moment and search below!', 'mojito-core' ),
        ],
        [
            'id'      => 'tx_error_link_text',
            'type'    => 'text',
            'title'   => esc_html__( '404 Button', 'mojito-core' ),
            'default' => esc_html__( 'Go Back to Home ', 'mojito-core' ),
        ],

    ],
] );