<?php

CSF::createSection( $prefix . '_theme_options', [
    'title'  => esc_html__( 'Blog Details Settings', 'mojito-core' ),
    'parent' => 'blog_settings',
    'fields' => [
        [
            'type'    => 'subheading',
            'content' => '<h3>' . esc_html__( 'Blog Details Settings', 'mojito-core' ) . '</h3>',
        ],
        // enable social share
        [
            'id'      => 'tx_enable_social_share',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Enable Social Share', 'mojito-core' ),
            'default' => false,
        ],

        // social share heading
        [
            'id'      => 'tx_social_share_heading',
            'type'    => 'text',
            'title'   => esc_html__( 'Social Share Heading', 'mojito-core' ),
            'default' => esc_html__( 'Share Article', 'mojito-core' ),
            'dependency' => [ 'tx_enable_social_share', '==', 'true' ],
        ],

        // enable blog navigation
        [
            'id'      => 'tx_enable_blog_navigation',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Enable Blog Navigation', 'mojito-core' ),
            'default' => false,
        ],

        // blog_details_shape img
        [
            'id'      => 'blog_details_shape',
            'type'    => 'media',
            'title'   => esc_html__( 'Blog Details Shape Image', 'mojito-core' ),
        ],

    ],
] );
