

<section class="mt-video-play-section position-relative" data-background="<?php echo esc_url($settings['image_1']['url']) ? esc_url($settings['image_1']['url']) : ''; ?>">
    <div class="mt-video-play-content text-center">
        <div class="play-icon">
            <a class="video_box" href="<?php echo esc_url($settings['video_link']['url']); ?>">
            <?php if(!empty( $settings['image_2']['url'] )) : ?>
            <img src="<?php echo esc_url( $settings['image_2']['url'] ); ?>"
            alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_2']['url'] ); } ?>">
            <?php endif; ?>
            </a>
        </div>
        <div class="play-text headline ul-li">
            <?php if(!empty( $settings['heading_1'] )) : ?>
            <h2 class="title_text title_text_ani">
                <?php echo elh_element_kses_basic( $settings['heading_1'] ); ?>
            </h2>
            <?php endif; ?>

            <?php if( $settings['enable_feature_lists'] === 'yes' ) : ?>
            <ul>
                <?php foreach($settings['feature_lists'] as $list) :?>
                <li>
                    <?php \Elementor\Icons_Manager::render_icon( $list['feature_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <?php echo esc_html($list['feature_text']); ?>
            </li>
                <?php endforeach; ?>
            </ul>
            <?php endif; ?>

            <?php if( $settings['enable_button'] === 'yes' ) : ?>
            <div class="mt-btn-3 ver_3 mt-35  text-uppercase">
                <a class="tx-button" href="<?php echo esc_url($settings['button_link']['url']); ?>"
                    target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                    rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                        <?php echo esc_html($settings['button_text']); ?>
                    <?php
                        if(!empty( $settings['enable_button_icon'] === 'yes') ) {
                            \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );
                        }
                    ?>
                    </a>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>