<div class="pf-testimonial-2-slider wa-p-relative">

    <?php if(!empty( $settings['image_1']['url'] )) : ?>
    <img class="quote" src="<?php echo esc_url($settings['image_1']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_1']['url']) : ''); ?>">
    <?php endif; ?>

    <div class="swiper-container pf-t2-slider">
        <div class="swiper-wrapper">

            <!-- single-item -->
            <?php foreach($settings['testimonial_lists'] as $list) : ?>
            <div class="swiper-slide">
                <div class="pf-testimonial-2-slider-item">
                    <?php if(!empty( $list['author_image']['url'] )) : ?>
                    <div class="item-img wa-fix wa-img-cover">
                        <img src="<?php echo esc_url($list['author_image']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['author_image']['url']) : ''); ?>">
                    </div>
                    <?php endif; ?>

                    <div class="content">
                        <?php if( $list['enable_rating'] === 'yes' ) : ?>
                        <div class="pf-star">
                            <?php
                                $rating = $list['rating_star'];
                                for ($i = 1; $i <= 5; $i++) {
                                    if ($i <= $rating) {
                                        echo '<i class="fa-solid fa-star"></i>';
                                    } else {
                                        echo '<i class="fa-solid fa-star-empty"></i>';
                                    }
                                }
                            ?>
                        </div>
                        <?php endif; ?>
                        <?php if(!empty( $list['comment'] )) : ?>
                        <h5 class="pf-h-1 item-comment"><?php echo elh_element_kses_intermediate($list['comment']); ?></h5>
                        <?php endif; ?>

                        <?php if(!empty( $list['name'] )) : ?>
                        <h6 class="pf-h-1 author-name"><?php echo elh_element_kses_intermediate($list['name']); ?></h6>
                        <?php endif; ?>
                        <?php if(!empty( $list['designation'] )) : ?>
                        <p class="pf-p-1 author-bio"><?php echo elh_element_kses_intermediate($list['designation']); ?></p>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
            <?php endforeach; ?>

        </div>
    </div>

    <?php if( $settings['enable_slider_navigation'] === 'yes' ) : ?>
    <div class="pf-testimonial-2-slider-btn has-testimonial-8 pf-slider-hori-btn">
        <div class="pf-slider-hori-btn-single pf-t2-btn-next">
            <i class="fa-solid fa-chevron-right"></i>
        </div>
        <div class="pf-slider-hori-btn-single pf-t2-btn-prev">
            <i class="fa-solid fa-chevron-left"></i>
        </div>
    </div>
    <?php endif; ?>
</div>