<section class="mt-career-quote-section pt-110 pb-110 tx-section">
    <div class="container mt-container-1">
        <div class="mt-career-quote-content">
            <div class="mt-section-title headline pera-content">
                <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                <div class="subtitle wow fadeInUp tx-subTitle"  data-wow-delay="500ms" data-wow-duration="1000ms">
                    <?php echo elh_element_kses_basic( $settings['sub_title'] ); ?>
                </div>
                <?php endif; ?>
                <?php
                    if($settings['enable_title'] === 'yes') {
                    $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                        printf('<%1$s %2$s>%3$s</%1$s>',
                            tag_escape($settings['title_tag']),
                            $this->get_render_attribute_string('title'),
                            elh_element_kses_basic( $settings['title'] )
                        );
                    }
                ?>

                <?php if( $settings['enable_description'] === 'yes' ) : ?>
                <p class="tx-description">
                    <?php echo elh_element_kses_intermediate( $settings['description'] ); ?>
                </p>
                <?php endif; ?>
            </div>

            <div class="mt-career-qt-item mt-50 d-flex align-items-center  position-relative">
                <?php if(!empty( $settings['quote_icon'] )) : ?>
                <span class="qt-icon position-absolute">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['quote_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </span>
                <?php endif; ?>

                <?php if(!empty( $settings['author_image']['url'] )) : ?>
                <div class="item-img">
                    <img src="<?php echo esc_url($settings['author_image']['url']); ?>"
                    alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['author_image']['url']) : ''); ?>">
                </div>
                <?php endif; ?>
                <div class="item-text headline pera-content">
                    <?php if(!empty( $settings['comment'] )) : ?>
                    <p><?php echo elh_element_kses_intermediate($settings['comment']); ?></p>
                    <?php endif; ?>
                    <div class="item-author mt-40">
                        <?php if(!empty( $settings['name'] )) : ?>
                        <h4  class="text-uppercase"><?php echo elh_element_kses_intermediate($settings['name']); ?></h4>
                        <?php endif; ?>

                        <?php if(!empty( $settings['designation'] )) : ?>
                        <span><?php echo elh_element_kses_intermediate($settings['designation']); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>