<section class="mt-testimonial-section-4 pt-110 tx-section">
    <div class="container mt-container-1">
        <div class="mt-testimonial-content-4 d-flex align-items-center">
            <div class="mt-testimonial-img-wrap-4">
                <div class="mt-testimonial-img-thumb swiper-container">
                    <div class="swiper-wrapper">
                        <?php foreach($settings['testimonial_lists'] as $list) : ?>
                        <div class="swiper-slide">
                            <div class="mt-testi-img-4">
                                <img src="<?php echo esc_url($list['author_image']['url']); ?>"
                                alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['author_image']['url']) : ''); ?>">
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <div class="mt-testimonial-text-wrap-4 headline">
                <?php if(!empty( $settings['testimonial_heading'] )) : ?>
                <h3>
                    <?php echo elh_element_kses_intermediate($settings['testimonial_heading']); ?>
                </h3>
                <?php endif; ?>
                <div class="mt-testimonial-slide-4 mt-25 swiper-container">
                    <div class="swiper-wrapper">
                        <?php foreach($settings['testimonial_lists'] as $list) :?>
                        <div class="swiper-slide">
                            <div class="mt-testimonial-item-4 headline pera-content">
                                <?php if(!empty( $list['comment'] )) : ?>
                                <p><?php echo elh_element_kses_intermediate($list['comment']); ?></p>
                                <?php endif; ?>

                                <div class="mt-testi-author mt-55">
                                    <?php if(!empty( $list['name'] )) : ?>
                                    <h3><?php echo elh_element_kses_intermediate($list['name']); ?></h3>
                                    <?php endif; ?>

                                    <?php if(!empty( $list['designation'] )) : ?>
                                    <span class="text-uppercase"><?php echo elh_element_kses_intermediate($list['designation']); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <?php if( $settings['enable_slider_navigation'] === 'yes' ) : ?>
            <div class="mt-testimonial-nav-4">
                <div class="nav-wrap">
                    <div class="mt-test-prev-4"><i class="fa-solid fa-chevron-left"></i></div>
                    <div class="mt-test-next-4"><i class="fa-solid fa-chevron-right"></i></div>
                </div>
            </div>
            <?php endif; ?>

        </div>
    </div>
</section>