<section class="mt-testimonial-section-3 pt-120 pb-120 tx-section">
    <div class="container mt-container-1">
        <div class="mt-testimonial-content-3 d-flex">
            <div class="mt-testimonial-thumb pt-45">
                <div class="mt-section-title ver_2 headline">
                    <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                    <div class="subtitle-2 wow fadeInRight tx-subTitle"  data-wow-delay="300ms" data-wow-duration="1000ms">
                        <?php echo elh_element_kses_basic( $settings['sub_title'] ); ?>
                    </div>
                    <?php endif; ?>

                    <?php
                        if($settings['enable_title'] === 'yes') {
                        $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                            printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                elh_element_kses_basic( $settings['title'] )
                            );
                        }
                    ?>

                    <?php if( $settings['enable_description'] === 'yes' ) : ?>
                    <p class="tx-description">
                        <?php echo elh_element_kses_intermediate( $settings['description'] ); ?>
                    </p>
                    <?php endif; ?>
                </div>
                <div class="testimonial-thumbs-area mt-70">
                    <div class="mt-testi-thumb-active swiper-container">
                        <div class="swiper-wrapper">
                            <?php foreach($settings['testimonial_lists'] as $list) : ?>
                            <div class="swiper-slide">
                                <div class="testi-thumb">
                                    <img src="<?php echo esc_url($list['author_image']['url']); ?>"
                                alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['author_image']['url']) : ''); ?>">
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mt-testimonial-slide-wrap">
                <div class="mt-testimonial-slide swiper-container">
                    <div class="swiper-wrapper">
                        <?php foreach($settings['testimonial_lists'] as $list) :
                            $is_active = $list['is_active'] === 'yes' ? 'active' : '';
                        ?>
                        <div class="swiper-slide">
                            <div class="mt-testi-item-3 d-flex align-items-center">
                                <?php if(!empty( $list['author_image']['url'] )) : ?>
                                <div class="item-img">
                                    <div class="inner-img">
                                        <img src="<?php echo esc_url($list['author_image']['url']); ?>"
                                    alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['author_image']['url']) : ''); ?>">
                                    </div>
                                </div>
                                <?php endif; ?>

                                <div class="item-text pera-content">
                                <?php if(!empty( $list['comment'] )) : ?>
                                <p><?php echo elh_element_kses_intermediate($list['comment']); ?></p>
                                <?php endif; ?>
                                    <div class="item-author ul-li">
                                        <?php if( $list['enable_rating'] === 'yes' ) : ?>
                                        <ul>
                                            <?php
                                                $rating = $list['rating_star'];
                                                for ($i = 1; $i <= 5; $i++) {
                                                    if ($i <= $rating) {
                                                        echo '<li><i class="fa-solid fa-star"></i></li>';
                                                    } else {
                                                        echo '<li><i class="fa-solid fa-star-empty"></i></li>';
                                                    }
                                                }
                                            ?>
                                        </ul>
                                        <?php endif; ?>
                                        <div class="name-degi d-flex align-items-center">
                                            <?php if(!empty( $list['name'] )) : ?>
                                            <h3><?php echo elh_element_kses_intermediate($list['name']); ?></h3>
                                            <?php endif; ?>

                                            <?php if(!empty( $list['designation'] )) : ?>
                                            <span class="text-uppercase"><?php echo elh_element_kses_intermediate($list['designation']); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>