<section class="mt-team-service-section pt-120 pb-120 tx-section">
    <div class="container mt-container-1">
        <div class="mt-team-service-content d-flex">
            <div class="mt-team-content-2 position-relative d-flex flex-wrap">
                <?php foreach($settings['testimonial_lists'] as $list) : ?>
                <div class="mt-team-item-2">
                    <div class="item-img d-flex justify-content-center align-items-center">
                        <?php if(!empty( $list['author_image']['url'] )) : ?>
                        <img src="<?php echo esc_url($list['author_image']['url']); ?>"
                        alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['author_image']['url']) : ''); ?>">
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>

                <?php if( $settings['enable_slider_navigation'] === 'yes' ) : ?>
                <div class="mt-ser-slider-nav  d-flex align-items-center justify-content-center">
                    <div class="mt-ser-prev d-flex align-items-center justify-content-center"><i class="fas fa-chevron-left"></i></div>
                    <div class="mt-ser-next d-flex align-items-center justify-content-center"><i class="fas fa-chevron-right"></i></div>
                </div>
                <?php endif; ?>

            </div>
            <div class="mt-service-content-2">
                <div class="mt-service-slide swiper-container">
                    <div class="swiper-wrapper">
                        <?php foreach($settings['testimonial_lists'] as $list) : ?>
                        <div class="swiper-slide">
                            <div class="mt-service-item align-items-center d-flex flex-wrap">
                                <?php if(!empty( $list['count'] )) : ?>
                                <div class="item-serial">
                                    <?php echo esc_html($list['count']); ?>
                                </div>
                                <?php endif; ?>
                                <div class="item-text headline pera-content">
                                    <?php if(!empty( $list['top_heading'] )) : ?>
                                    <h3 class="href-underline">
                                        <a href="<?php echo esc_url($list['link']['url']); ?>"
                                        target="<?php echo esc_attr($list['link']['is_external'] ? '_blank' : '_self'); ?>"
                                        rel="<?php echo esc_attr($list['link']['nofollow'] ? 'nofollow' : ''); ?>">
                                            <?php echo elh_element_kses_intermediate($list['top_heading']); ?>
                                        </a>
                                    </h3>
                                    <?php endif; ?>

                                    <?php if(!empty( $list['comment'] )) : ?>
                                    <p><?php echo elh_element_kses_intermediate($list['comment']); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>