<section class="mt-testimonial-section pt-120 pb-80 tx-section">
    <div class="container mt-container-1">
        <div class="mt-testimonial-top d-flex justify-content-between flex-wrap align-items-end">
            <div class="mt-section-title  headline pera-content">
                <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                <div class="subtitle wow fadeInRight" data-wow-delay="400ms" data-wow-duration="1000ms">
                    <?php echo elh_element_kses_basic( $settings['sub_title'] ); ?>
                </div>
                <?php endif; ?>

                <?php
                    if($settings['enable_title'] === 'yes') {
                    $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                        printf('<%1$s %2$s>%3$s</%1$s>',
                            tag_escape($settings['title_tag']),
                            $this->get_render_attribute_string('title'),
                            elh_element_kses_basic( $settings['title'] )
                        );
                    }
                ?>
            </div>

            <?php if( $settings['enable_description'] === 'yes' ) : ?>
            <div class="top-text pera-content mt-text">
                <p class="tx-description">
                    <?php echo elh_element_kses_intermediate( $settings['description'] ); ?>
                </p>
            </div>
            <?php endif; ?>
        </div>
        <div class="mt-testimonial-content txt_item_active mb-70 d-flex justify-content-center">
            <?php foreach($settings['testimonial_lists'] as $list) :
                $is_active = $list['is_active'] === 'yes' ? 'active' : '';
            ?>
            <div class="mt-testimonial-item <?php echo esc_attr($is_active); ?> d-flex">
                <?php if(!empty( $list['author_image']['url'] )) : ?>
                <div class="item-img position-relative">
                    <img src="<?php echo esc_url($list['author_image']['url']); ?>"
                    alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['author_image']['url']) : ''); ?>">
                </div>
                <?php endif; ?>
                <div class="item-text headline d-flex flex-wrap position-relative  pera-content">
                    <?php if(!empty( $list['quote_icon'] )) : ?>
                    <div class="item-icon position-absolute">
                        <?php \Elementor\Icons_Manager::render_icon( $list['quote_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </div>
                    <?php endif; ?>
                    <div class="item-title">
                        <?php if(!empty( $list['top_heading'] )) : ?>
                        <h3>
                            <span><?php echo elh_element_kses_intermediate($list['top_heading']); ?></span>
                        </h3>
                        <?php endif; ?>

                        <?php if(!empty( $list['comment'] )) : ?>
                        <p><?php echo elh_element_kses_intermediate($list['comment']); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="rate-name ul-li">
                        <?php if( $list['enable_rating'] === 'yes' ) : ?>
                        <ul>
                            <?php
                                $rating = $list['rating_star'];
                                for ($i = 1; $i <= 5; $i++) {
                                    if ($i <= $rating) {
                                        echo '<li><i class="fa-solid fa-star"></i></li>';
                                    } else {
                                        echo '<li><i class="fa-solid fa-star-empty"></i></li>';
                                    }
                                }
                            ?>
                        </ul>
                        <?php endif; ?>

                        <div class="item-name">
                            <?php if(!empty( $list['name'] )) : ?>
                            <h4><?php echo elh_element_kses_intermediate($list['name']); ?></h4>
                            <?php endif; ?>

                            <?php if(!empty( $list['designation'] )) : ?>
                            <span><?php echo elh_element_kses_intermediate($list['designation']); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>