<?php
namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Repeater;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Testimonial extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Mojito Core widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_testimonial';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Testimonial', 'mojito-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['count', 'mojito', 'mojito testimonial', 'testimonial', 'mojito testimonial widget'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_choose_style',
            [
                'label' => __( 'CHOOSE DESIGN STYLE', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                    'style_2' => __( 'Style 2', 'mojito-core' ),
                    'style_3' => __( 'Style 3', 'mojito-core' ),
                    'style_4' => __( 'Style 4', 'mojito-core' ),
                    'style_5' => __( 'Style 5', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_title',
            [
                'label'     => __( 'Title & Description', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1', 'style_3', 'style_5'],
                ],
            ]
        );

        // sub title
        $this->add_control(
            'sub_title',
            [
                'label'       => __( 'Sub Title', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'Sub Title',
                'placeholder' => __( 'Sub Title Text', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_sub_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'Heading Title',
                'placeholder' => __( 'Heading Text', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'     => __( 'Title HTML Tag', 'mojito-core' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'h1' => [
                        'title' => __( 'H1', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => __( 'H2', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default'   => 'h2',
                'toggle'    => false,
                'condition' => [
                    'enable_title' => 'yes',
                ],
            ]
        );

        // description
        $this->add_control(
            'description',
            [
                'label'       => __( 'Description', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'The opportunity to work abroad is a popular prospect, one',
                'placeholder' => __( 'Description Text', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_description' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // images
        $this->start_controls_section(
            '_section_images',
            [
                'label'     => __( 'Images', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
            ]
        );

        // mask image
        $this->add_control(
            'mask_image',
            [
                'label'       => __( 'Mask Image', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'selectors'   => [
                    '{{WRAPPER}} .mt-testimonial-section'           => 'mask-image: url({{URL}});-webkit-mask-image: url({{URL}});',
                ],
            ]
        );

        // END
        $this->end_controls_section();

        $this->start_controls_section(
            '_section_testimonial',
            [
                'label'     => __( 'Testimonials', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1', 'style_2', 'style_3', 'style_4'],
                ],
            ]
        );

        // testimonail heading
        $this->add_control(
            'testimonial_heading',
            [
                'label'       => __( 'Testimonial Heading', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your testimonial heading', 'mojito-core' ),
                'default'     => __( 'What Says Our Clients’s About Diligent', 'mojito-core' ),
                'condition'   => [
                    'design_style' => ['style_4'],
                ],
            ]
        );

        // repeater
        $repeater = new Repeater();

        // design style
        $repeater->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                    'style_2' => __( 'Style 2', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // is_active
        $repeater->add_control(
            'is_active',
            [
                'label'        => __( 'Active', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        $repeater->add_control(
            'author_image',
            [
                'label'   => __( 'Author Image', 'mojito-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // quote icon
        $repeater->add_control(
            'quote_icon',
            [
                'label'     => __( 'Quote Icon', 'mojito-core' ),
                'type'      => Controls_Manager::ICONS,
                'default'   => [
                    'value'   => 'fas fa-quote-left',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // count
        $repeater->add_control(
            'count',
            [
                'label'       => __( 'Count', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '1', 'mojito-core' ),
                'condition'   => [
                    'design_style' => ['style_2'],
                ],
            ]
        );

        // top heading
        $repeater->add_control(
            'top_heading',
            [
                'label'       => __( 'Top Heading', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your top heading', 'mojito-core' ),
                'default'     => __( 'Top Heading', 'mojito-core' ),
                'condition'   => [
                    'design_style' => ['style_1', 'style_2'],
                ],
            ]
        );

        // link
        $repeater->add_control(
            'link',
            [
                'label'       => __( 'Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'default'     => [
                    'url' => '#',
                ],
                'condition'   => [
                    'design_style' => ['style_2'],
                ],
            ]
        );

        // content
        $repeater->add_control(
            'comment',
            [
                'label'       => __( 'Comment', 'mojito-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your content', 'mojito-core' ),
                'default'     => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'mojito-core' ),
            ]
        );

        // name
        $repeater->add_control(
            'name',
            [
                'label'       => __( 'Name', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your name', 'mojito-core' ),
                'default'     => __( 'John Doe', 'mojito-core' ),
                'condition'   => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // designation
        $repeater->add_control(
            'designation',
            [
                'label'       => __( 'Designation', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your designation', 'mojito-core' ),
                'default'     => __( 'CEO', 'mojito-core' ),
                'condition'   => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // enable_rating
        $repeater->add_control(
            'enable_rating',
            [
                'label'        => __( 'Enable Rating', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'   => [
                    'design_style' => ['style_1'],
                ],
            ]
        );

        // rating star
        $repeater->add_control(
            'rating_star',
            [
                'label'     => __( 'Rating Star', 'mojito-core' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    '1' => __( '1 Star', 'mojito-core' ),
                    '2' => __( '2 Star', 'mojito-core' ),
                    '3' => __( '3 Star', 'mojito-core' ),
                    '4' => __( '4 Star', 'mojito-core' ),
                    '5' => __( '5 Star', 'mojito-core' ),
                ],
                'default'   => '5',
                'condition' => [
                    'enable_rating' => 'yes',
                    'design_style' => ['style_1'],
                ],
            ]
        );

        $this->add_control(
            'testimonial_lists',
            [
                'label'       => __( 'Testimonial Lists', 'mojito-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();

        // TESTIMONIAL BOX
        $this->start_controls_section(
            '_section_testimonial_box',
            [
                'label'     => __( 'Testimonial Box', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_5'],
                ],
            ]
        );

        // author image
        $this->add_control(
            'author_image',
            [
                'label'   => __( 'Author Image', 'mojito-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // quote icon
        $this->add_control(
            'quote_icon',
            [
                'label'     => __( 'Quote Icon', 'mojito-core' ),
                'type'      => Controls_Manager::ICONS,
                'default'   => [
                    'value'   => 'fas fa-quote-left',
                    'library' => 'fa-solid',
                ],
            ]
        );

        // content
        $this->add_control(
            'comment',
            [
                'label'       => __( 'Comment', 'mojito-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your content', 'mojito-core' ),
                'default'     => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'mojito-core' ),
            ]
        );

        // name
        $this->add_control(
            'name',
            [
                'label'       => __( 'Name', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your name', 'mojito-core' ),
                'default'     => __( 'John Doe', 'mojito-core' ),
            ]
        );

        // designation
        $this->add_control(
            'designation',
            [
                'label'       => __( 'Designation', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your designation', 'mojito-core' ),
                'default'     => __( 'CEO', 'mojito-core' ),
            ]
        );

        $this->end_controls_section();

        // settings
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // enable_slide_pagination
        $this->add_control(
            'enable_slide_pagination',
            [
                'label'        => __( 'Enable Slide Pagination', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // enable_slider_navigation
        $this->add_control(
            'enable_slider_navigation',
            [
                'label'        => __( 'Enable Slider Navigation', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'mojito-core' ),
                'label_off'    => __( 'No', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE SUB TITLE
        $this->add_control(
            'enable_sub_title',
            [
                'label'        => __( 'Enable Sub Title', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => ['style_1', 'style_3'],
                ],
            ]
        );

        // ENABLE TITLE
        $this->add_control(
            'enable_title',
            [
                'label'        => __( 'Enable Title', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE DESCRIPTION
        $this->add_control(
            'enable_description',
            [
                'label'        => __( 'Enable Description', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // end
        $this->end_controls_section();

    }

    protected function register_style_controls() {
        $dir = dirname( __FILE__ );

        $style_files = glob( $dir . '/styles/*.php' );

        if ( $style_files ) {
            foreach ( $style_files as $style_file ) {
                include $style_file;
            }
        }
    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty( $settings['design_style'] ) ? $settings['design_style'] : 'style_1';

        switch ( $style ) {
        case 'style_7':
            include $dir . '/views/view-7.php';
            break;
        case 'style_6':
            include $dir . '/views/view-6.php';
            break;
        case 'style_5':
            include $dir . '/views/view-5.php';
            break;
        case 'style_4':
            include $dir . '/views/view-4.php';
            break;
        case 'style_3':
            include $dir . '/views/view-3.php';
            break;
        case 'style_2':
            include $dir . '/views/view-2.php';
            break;
        default:
            include $dir . '/views/view-1.php';
        }
    }
}
