<?php
    $anim_class = '';
    if ( $settings['enable_animation'] === 'yes' ) {
        $anim_class = $settings['anim_class'];
    }
?>
<div class="mt-team-item-4 text-center <?php echo esc_attr( $anim_class ); ?>">
    <div class="item-img position-relative">
        <?php if(!empty( $settings['team_image']['url'] )) : ?>
        <div class="inner-img">
            <img src="<?php echo esc_url( $settings['team_image']['url'] ); ?>"
            alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['team_image']['url'] ); } ?>">
        </div>
        <?php endif; ?>

        <?php if( $settings['enable_social_links'] === 'yes' ) : ?>
        <div class="item-icon position-absolute">
            <?php foreach($settings['social_links'] as $s_list) : ?>
            <a href="<?php echo esc_url($s_list['social_link']['url']); ?>"
                target="<?php echo esc_attr( $s_list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
                rel="<?php echo esc_attr( $s_list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>" aria-label="name">
                <?php \Elementor\Icons_Manager::render_icon( $s_list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </a>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
    <div class="item-text headline">
        <?php if(!empty( $settings['name'] )) : ?>
        <h3 class="person-name pf-h-5">
            <a
            href="<?php echo esc_url($settings['link']['url']); ?>"
            target="<?php echo esc_attr($settings['link']['is_external'] ? '_blank' : '_self'); ?>"
            rel="<?php echo esc_attr($settings['link']['nofollow'] ? 'nofollow' : ''); ?>">
                <?php echo elh_element_kses_intermediate( $settings['name'] ); ?>
            </a>
        </h3>
        <?php endif; ?>

        <?php if(!empty( $settings['designation'] )) : ?>
        <span><?php echo elh_element_kses_intermediate( $settings['designation'] ); ?></span>
        <?php endif; ?>
    </div>
</div>