<section class="mt-team-section-3 pt-120 pb-100 position-relative tx-section">
    <?php if(!empty( $settings['image_1']['url'] )) : ?>
    <span class="team-shape1 position-absolute appear_right_2">
        <img src="<?php echo esc_url( $settings['image_1']['url'] ); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_1']['url'] ); } ?>" />
    </span>
    <?php endif; ?>

    <?php if(!empty( $settings['image_2']['url'] )) : ?>
    <span class="team-shape2 position-absolute appear_left_2">
        <img src="<?php echo esc_url( $settings['image_2']['url'] ); ?>"
        alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_2']['url'] ); } ?>" />
    </span>
    <?php endif; ?>
    <div class="container mt-container-1">
        <div class="mt-team-content-3 position-relative">
            <div class="mt-team-text-wrap mt-text headline pera-content">
                <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                <h3 class="title_text title_text_ani">
                    <?php echo elh_element_kses_intermediate($settings['sub_title']); ?>
                </h3>
                <?php endif; ?>

                <?php if( $settings['enable_description'] === 'yes' ) : ?>
                <p>
                    <?php echo elh_element_kses_intermediate($settings['description']); ?>
                </p>
                <?php endif; ?>

                <?php if( $settings['enable_social_links'] === 'yes' ) : ?>
                <div class="item-social d-flex text-uppercase wow fadeInUp" data-wow-delay="450ms" data-wow-duration="1000ms">
                    <?php foreach( $settings['social_links'] as $list ) : ?>
                    <a aria-label="Social Link" class="link" href="<?php echo esc_url($list['social_link']['url']); ?>"
                    target="<?php echo esc_attr( $list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
                    rel="<?php echo esc_attr( $list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>">
                        <?php \Elementor\Icons_Manager::render_icon( $list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        <?php echo esc_html($list['social_name']); ?>
                    </a>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
            <div class="mt-team-slider-area d-flex justify-content-end">
                <div class="mt-team-slider-wrap">
                    <div class="mt-team-slider swiper-container">
                        <div class="swiper-wrapper">
                            <?php foreach ($settings['team_member_lists'] as $list) : ?>
                            <div class="swiper-slide">
                                <div class="mt-team-item-3 position-relative">
                                    <?php if(!empty( $list['team_member_image']['url'] )) : ?>
                                    <div class="team-img d-flex justify-content-end">
                                        <div class="item-img">
                                            <img src="<?php echo esc_url( $list['team_member_image']['url'] ); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $list['team_member_image']['url'] ); } ?>" />
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                    <?php if(!empty( $list['team_member_name'] )) : ?>
                                    <div class="team-text headline">
                                        <h3>
                                            <?php echo elh_element_kses_intermediate( $list['team_member_name'] ); ?>
                                        </h3>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-team-slider-nav  d-flex align-items-center ">
                <div class="mt-team-prev d-flex align-items-center justify-content-center"><i class="fas fa-chevron-left"></i></div>
                <div class="mt-team-next d-flex align-items-center justify-content-center"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </div>
</section>