<section class="mt-team-section pt-125 position-relative">
    <span class="mt-team-shape position-absolute appear_right_2">
        <?php if(!empty( $settings['top_bg_image']['url'] )) : ?>
        <img src="<?php echo esc_url( $settings['top_bg_image']['url'] ); ?>"
        alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['top_bg_image']['url'] ); } ?>">
        <?php endif; ?>
    </span>
    <div class="container mt-container-1">
        <div class="mt-team-top-content flex-wrap d-flex justify-content-between">
            <div class="mt-section-title headline pera-content">
                <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                <div class="subtitle wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                    <?php echo elh_element_kses_intermediate( $settings['sub_title'] ); ?>
                </div>
                <?php endif; ?>

                <?php
                    if($settings['enable_title'] === 'yes') {
                    $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                        printf('<%1$s %2$s>%3$s</%1$s>',
                            tag_escape($settings['title_tag']),
                            $this->get_render_attribute_string('title'),
                            elh_element_kses_basic( $settings['title'] )
                        );
                    }
                ?>
            </div>
            <div class="top-text-btn pera-content">
                <?php if( $settings['enable_description'] === 'yes' ) : ?>
                <p><?php echo elh_element_kses_intermediate( $settings['description'] ); ?></p>
                <?php endif; ?>

                <?php if( $settings['enable_button'] === 'yes' ) : ?>
                <div class="mt-btn-1 ver_2 text-uppercase">
                    <a class="tx-button" href="<?php echo esc_url($settings['button_link']['url']); ?>"
                    target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                    rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                        <span><?php echo esc_html($settings['button_text']); ?></span>
                    <?php
                        if(!empty( $settings['enable_button_icon'] === 'yes') ) {
                            \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );
                        }
                    ?>
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="mt-team-content d-flex pt-55">
            <?php if(!empty( $settings['team_image_1']['url'] )) : ?>
            <div class="mt-team-item appear_left_1">
                <img src="<?php echo esc_url( $settings['team_image_1']['url'] ); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['team_image_1']['url'] ); } ?>">
            </div>
            <?php endif; ?>

            <?php if(!empty( $settings['team_image_2']['url'] )) : ?>
            <div class="mt-team-item appear_left_2">
                <img src="<?php echo esc_url( $settings['team_image_2']['url'] ); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['team_image_2']['url'] ); } ?>">
            </div>
            <?php endif; ?>

            <?php if(!empty( $settings['team_image_3']['url'] )) : ?>
            <div class="mt-team-item">
                <img src="<?php echo esc_url( $settings['team_image_3']['url'] ); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['team_image_3']['url'] ); } ?>">
            </div>
            <?php endif; ?>

            <?php if(!empty( $settings['team_image_4']['url'] )) : ?>
            <div class="mt-team-item appear_right_1">
                <img src="<?php echo esc_url( $settings['team_image_4']['url'] ); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['team_image_4']['url'] ); } ?>">
            </div>
            <?php endif; ?>

            <?php if(!empty( $settings['team_image_5']['url'] )) : ?>
            <div class="mt-team-item appear_right_2">
                <img src="<?php echo esc_url( $settings['team_image_5']['url'] ); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['team_image_5']['url'] ); } ?>">
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>