<div class="vt-team-list-item">
    <div class="vt-team-list-area flex-wrap headline d-flex align-items-center justify-content-between position-relative">
        <div class="item-img-name d-flex align-items-center">
            <?php if(!empty( $settings['team_image']['url'] )) : ?>
            <div class="item-img position-relative">
                <img src="<?php echo esc_url( $settings['team_image']['url'] ); ?>"
                alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['team_image']['url'] ); } ?>">
            </div>
            <?php endif; ?>

            <?php if(!empty( $settings['name'] )) : ?>
            <div class="item-name headline">
                <h3>
                    <a
                    href="<?php echo esc_url($settings['link']['url']); ?>"
                    target="<?php echo esc_attr($settings['link']['is_external'] ? '_blank' : '_self'); ?>"
                    rel="<?php echo esc_attr($settings['link']['nofollow'] ? 'nofollow' : ''); ?>">
                        <?php echo elh_element_kses_intermediate( $settings['name'] ); ?>
                    </a>
                </h3>
            </div>
            <?php endif; ?>
        </div>
        <?php if(!empty( $settings['designation'] )) : ?>
        <div class="item-degi">
            <?php echo elh_element_kses_intermediate( $settings['designation'] ); ?>
        </div>
        <?php endif; ?>

        <?php if(!empty( $settings['button_text'] )) : ?>
        <div class="item-place">
            <?php echo elh_element_kses_intermediate( $settings['button_text'] ); ?>
        </div>
        <?php endif; ?>

        <?php if(!empty( $settings['button_icon'] )) : ?>
        <div class="item-arrow">
            <a
                href="<?php echo esc_url($settings['link']['url']); ?>"
                target="<?php echo esc_attr($settings['link']['is_external'] ? '_blank' : '_self'); ?>"
                rel="<?php echo esc_attr($settings['link']['nofollow'] ? 'nofollow' : ''); ?>">
                <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>