<div class="pf-team-1-slider p-relative">
    <div class="swiper-container wa-fix pf-team-1-active">
        <div class="swiper-wrapper">

            <?php foreach($settings['team_members'] as $list) : ?>
            <div class="swiper-slide">
                <div class="pf-team-1-slider-item">
                    <div class="item-img wa-img-cover">
                        <?php if(!empty( $list['team_image']['url'] )) : ?>
                        <img src="<?php echo esc_url( $list['team_image']['url'] ); ?>"
                        alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $list['team_image']['url'] ); } ?>">
                        <?php endif; ?>

                        <?php if( $list['enable_social_links'] === 'yes' ) : ?>
                        <div class="item-social">
                            <ul class="pf-team-1-social list-unstyled">
                                <?php foreach($list['social_links'] as $s_list) : ?>
                                <li>
                                    <a href="<?php echo esc_url($s_list['social_link']['url']); ?>"
                                    target="<?php echo esc_attr( $s_list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
                                    rel="<?php echo esc_attr( $s_list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>" aria-label="name">
                                    <?php \Elementor\Icons_Manager::render_icon( $s_list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                        <?php endif; ?>

                    </div>

                    <?php if(!empty( $list['name'] )) : ?>
                    <h5 class="person-name pf-h-5">
                        <a
                        href="<?php echo esc_url($list['link']['url']); ?>"
                        target="<?php echo esc_attr($list['link']['is_external'] ? '_blank' : '_self'); ?>"
                        rel="<?php echo esc_attr($list['link']['nofollow'] ? 'nofollow' : ''); ?>">
                            <?php echo elh_element_kses_intermediate( $list['name'] ); ?>
                        </a>
                    </h5>
                    <?php endif; ?>

                    <?php if(!empty( $list['designation'] )) : ?>
                    <p class="person-disc pf-p-6"><?php echo elh_element_kses_intermediate( $list['designation'] ); ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <?php if( $settings['enable_pagination'] === 'yes' ) : ?>
    <div class="pf-team-1-slider-pagination fx-t1-pagination mt-30"></div>
    <?php endif; ?>
</div>