<section class="mt-service-section-6 pb-120 tx-section">
    <div class="container mt-container-1">
        <div class="mt-service-content-6 d-flex">
            <div class="mt-service-tab-btn-4 ul-li-block">
                <div class="mt-section-title  headline">
                    <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                    <div class="subtitle-2 wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                        <?php echo elh_element_kses_intermediate( $settings['sub_title'] ); ?>
                    </div>
                    <?php
                    endif;
                        if($settings['enable_title'] === 'yes') {
                        $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                            printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                elh_element_kses_basic( $settings['title'] )
                            );
                        }
                    if( $settings['enable_description'] === 'yes' ) : ?>
                    <p class="tx-description"><?php echo elh_element_kses_intermediate($settings['description']); ?></p>
                    <?php endif; ?>
                </div>
                <div class="mt-service-tab-btn-list mt-45">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <?php
                            foreach ($settings['txTab_lists'] as $id => $list):
                            $_id = $id + 1;
                            $is_active = $list['is_active'] == 'yes' ? 'active' : '';
                            $aria_selected = $list['is_active'] == 'yes' ? 'true' : 'false';
                        ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php echo esc_attr($is_active); ?>"
                            id="projectTab-<?php echo esc_attr($id. '_' .$rand); ?>"
                            data-bs-toggle="tab"
                            data-bs-target="#tab-<?php echo esc_attr($id. '_' .$rand); ?>"
                            type="button"
                            role="tab"
                            aria-controls="tab-<?php echo esc_attr($id. '_' .$rand); ?>"
                            aria-selected="<?php echo esc_attr($aria_selected); ?>">
                                <?php if(!empty( $list['tab_count'] )) : ?>
                                <span><?php echo esc_html($list['tab_count']); ?></span>
                                <?php endif; ?>
                                <?php if(!empty( $list['tab_title'] )) : ?>
                                <strong><?php echo elh_element_kses_intermediate($list['tab_title']); ?></strong>
                                <?php endif; ?>
                                <?php \Elementor\Icons_Manager::render_icon( $list['tab_icon'], [ 'aria-hidden' => 'true' ] );  ?>
                            </button>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
            <div class="mt-service-tab-desc-4 mt-45">
                <div class="tab-content" id="nav-tabContent">
                    <?php
                        foreach ($settings['txTab_lists'] as $id => $list):
                        $is_active = $list['is_active'] == 'yes' ? 'show active' : '';
                    ?>
                    <div class="tab-pane animated fadeInUp <?php echo esc_attr($is_active); ?>"
                        id="tab-<?php echo esc_attr($id. '_' .$rand); ?>"
                        role="tabpanel"
                        aria-labelledby="projectTab-<?php echo esc_attr($id. '_' .$rand); ?>">
                        <div class="mt-service-desc-area d-flex align-items-center">
                            <?php if(!empty( $list['tab_image_1']['url'] )) : ?>
                            <div class="ser-item-img">
                                <img src="<?php echo esc_url($list['tab_image_1']['url']); ?>"
                                alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['tab_image_1']['url']) : ''); ?>">
                            </div>
                            <?php endif; ?>

                            <div class="service-item-area">
                                <?php if( $list['enable_service_box_1'] === 'yes' ) : ?>
                                <div class="service-item">
                                    <?php if(!empty( $list['service_box_1_image']['url'] )) : ?>
                                    <div class="item-img">
                                        <img src="<?php echo esc_url($list['service_box_1_image']['url']); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $list['service_box_1_image']['url'] ); } ?>">
                                    </div>
                                    <?php endif; ?>

                                    <div class="item-text headline pera-content">
                                        <?php if(!empty( $list['service_box_1_title'] )) : ?>
                                        <h3><a href="#"><?php echo esc_html($list['service_box_1_title']); ?></a></h3>
                                        <?php endif; ?>

                                        <?php if(!empty( $list['service_box_1_description'] )) : ?>
                                        <p><?php echo elh_element_kses_intermediate($list['service_box_1_description']); ?></p>
                                        <?php endif; ?>

                                        <?php if(!empty( $list['service_box_1_button_icon'] )) : ?>
                                        <a class="read_more" href="<?php echo esc_url($list['service_box_1_button_link']['url']); ?>"
                                            target="<?php echo esc_attr($list['service_box_1_button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                            rel="<?php echo esc_attr($list['service_box_1_button_link']['is_external'] ? 'noopener noreferrer' : ''); ?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $list['service_box_1_button_icon'], [ 'aria-hidden' => 'true' ] );  ?>
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <?php if( $list['enable_service_box_2'] === 'yes' ) : ?>
                                <div class="service-item">
                                    <?php if(!empty( $list['service_box_2_image']['url'] )) : ?>
                                    <div class="item-img">
                                        <img src="<?php echo esc_url($list['service_box_2_image']['url']); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $list['service_box_2_image']['url'] ); } ?>">
                                    </div>
                                    <?php endif; ?>

                                    <div class="item-text headline pera-content">
                                        <?php if(!empty( $list['service_box_2_title'] )) : ?>
                                        <h3><a href="#"><?php echo esc_html($list['service_box_2_title']); ?></a></h3>
                                        <?php endif; ?>

                                        <?php if(!empty( $list['service_box_2_description'] )) : ?>
                                        <p><?php echo elh_element_kses_intermediate($list['service_box_2_description']); ?></p>
                                        <?php endif; ?>

                                        <?php if(!empty( $list['service_box_2_button_icon'] )) : ?>
                                        <a class="read_more" href="<?php echo esc_url($list['service_box_2_button_link']['url']); ?>"
                                            target="<?php echo esc_attr($list['service_box_2_button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                            rel="<?php echo esc_attr($list['service_box_2_button_link']['is_external'] ? 'noopener noreferrer' : ''); ?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $list['service_box_2_button_icon'], [ 'aria-hidden' => 'true' ] );  ?>
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>