<?php $rand = rand(0, 9999); ?>
<section class="mt-service-section-4 pt-120 position-relative tx-section">
    <?php if(!empty( $settings['image_1']['url'] )) : ?>
    <div class="service-bg position-absolute">
        <img src="<?php echo esc_url($settings['image_1']['url']); ?>"
        alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_1']['url']) : ''); ?>">
    </div>
    <?php endif; ?>
    <div class="container mt-container-1">
        <div class="mt-service-content-4">
            <div class="mt-section-title ver_2 headline">
                <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                <div class="subtitle-2 wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                    <?php echo elh_element_kses_intermediate( $settings['sub_title'] ); ?>
                </div>
                <?php
                endif;
                    if($settings['enable_title'] === 'yes') {
                    $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                        printf('<%1$s %2$s>%3$s</%1$s>',
                            tag_escape($settings['title_tag']),
                            $this->get_render_attribute_string('title'),
                            elh_element_kses_basic( $settings['title'] )
                        );
                    }
                if( $settings['enable_description'] === 'yes' ) : ?>
                <p class="tx-description"><?php echo elh_element_kses_intermediate($settings['description']); ?></p>
                <?php endif; ?>
            </div>
            <div class="mt-service-tab-content">
                <div class="mt-service-tab-btn ul-li tx-tab-btn">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <?php
                            foreach ($settings['txTab_lists'] as $id => $list):
                            $_id = $id + 1;
                            $is_active = $list['is_active'] == 'yes' ? 'active' : '';
                            $aria_selected = $list['is_active'] == 'yes' ? 'true' : 'false';
                        ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php echo esc_attr($is_active); ?>"
                            id="projectTab-<?php echo esc_attr($id. '_' .$rand); ?>"
                            data-bs-toggle="tab"
                            data-bs-target="#tab-<?php echo esc_attr($id. '_' .$rand); ?>"
                            type="button"
                            role="tab"
                            aria-controls="tab-<?php echo esc_attr($id. '_' .$rand); ?>"
                            aria-selected="<?php echo esc_attr($aria_selected); ?>">
                            <?php if(!empty( $list['tab_count'] )) : ?>
                                <span><?php echo esc_html($list['tab_count']); ?></span>
                                <?php endif; ?><strong><?php echo elh_element_kses_intermediate($list['tab_title']); ?></strong>
                            </button>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <div class="mt-service-tab-desc">
                    <div class="tab-content" id="nav-tabContent">
                        <?php
                            foreach ($settings['txTab_lists'] as $id => $list):
                            $is_active = $list['is_active'] == 'yes' ? 'show active' : '';
                        ?>
                        <div class="tab-pane animated fadeInUp <?php echo esc_attr($is_active); ?>"
                        id="tab-<?php echo esc_attr($id. '_' .$rand); ?>"
                        role="tabpanel"
                        aria-labelledby="projectTab-<?php echo esc_attr($id. '_' .$rand); ?>">
                            <div class="mt-service-item-4 d-flex">
                                <div class="item-text headline pera-content">
                                    <div class="item-title d-flex align-items-center">
                                        <?php if(!empty( $list['tab_image_1']['url'] )) : ?>
                                        <div class="item-icon d-flex justify-content-center align-items-center">
                                            <img src="<?php echo esc_url($list['tab_image_1']['url']); ?>"
                                        alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['tab_image_1']['url']) : ''); ?>">
                                        </div>
                                        <?php endif; ?>

                                        <?php if(!empty( $list['tab_cat'] )) : ?>
                                        <div class="title-text">
                                            <?php echo elh_element_kses_intermediate($list['tab_cat']); ?>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    <?php if(!empty( $list['tab_content'] )) : ?>
                                    <p><?php echo wp_kses($list['tab_content'], true);?></p>
                                    <?php endif; ?>

                                    <?php if(!empty( $list['button_text'] )) : ?>
                                    <div class="mt-btn-3 ver_3 mt-20">
                                        <a class="tx-button text-uppercase" href="<?php echo esc_url($list['button_link']['url']); ?>"
                                        target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                        rel="<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                                            <?php echo esc_html($list['button_text']); ?>
                                            <?php \Elementor\Icons_Manager::render_icon( $list['button_icon'], [ 'aria-hidden' => 'true' ] );  ?>
                                        </a>
                                    </div>
                                    <?php endif; ?>
                                </div>

                                <?php if(!empty( $list['tab_image_2']['url'] )) : ?>
                                <div class="item-img position-relative">
                                    <img src="<?php echo esc_url($list['tab_image_2']['url']); ?>"
                                alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['tab_image_2']['url']) : ''); ?>">
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>