<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Repeater;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Tabs extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Mojito Core widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_tabs';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Tabs', 'mojito-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['country', 'tab'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_design_settings',
            [
                'label' => __( 'DESIGN STYLE', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                    'style_2' => __( 'Style 2', 'mojito-core' ),
                    'style_3' => __( 'Style 3', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        // images
        $this->start_controls_section(
            '_section_images',
            [
                'label' => __( 'Images', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // IMAGE_1
        $this->add_control(
            'image_1',
            [
                'label'       => __( 'Image 1', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        // shape iamge
        $this->add_control(
            'list_shape_image',
            [
                'label'       => __( 'Shape Image', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic'     => [
                    'active' => true,
                ],
                'selectors'   => [
                    '{{WRAPPER}} .mt-about-tab-text .tab-list li:before' => 'background-image: url({{URL}});',
                ],
                'condition'   => [
                   'design_style' => ['style_3'],
                ],
            ]
        );

        // END
        $this->end_controls_section();

        $this->start_controls_section(
            '_section_title',
            [
                'label'     => __( 'Title & Description', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1', 'style_2'],
                ],
            ]
        );

        // sub title
        $this->add_control(
            'sub_title',
            [
                'label'       => __( 'Sub Title', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'Sub Title',
                'placeholder' => __( 'Sub Title Text', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_sub_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'Heading Title',
                'placeholder' => __( 'Heading Text', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'     => __( 'Title HTML Tag', 'mojito-core' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'h1' => [
                        'title' => __( 'H1', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => __( 'H2', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'mojito-core' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default'   => 'h2',
                'toggle'    => false,
                'condition' => [
                    'enable_title' => 'yes',
                ],
            ]
        );

        // description
        $this->add_control(
            'description',
            [
                'label'       => __( 'Description', 'mojito-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'The opportunity to work abroad is a popular prospect, one',
                'placeholder' => __( 'Description Text', 'mojito-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_description' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_project_tab',
            [
                'label' => __( 'Tabs', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // repeater
        $repeater = new Repeater();

        // design style
        $repeater->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                    'style_2' => __( 'Style 2', 'mojito-core' ),
                    'style_3' => __( 'Style 3', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // is_active
        $repeater->add_control(
            'is_active',
            [
                'label'        => __( 'Active', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // tab count
        $repeater->add_control(
            'tab_count',
            [
                'label'       => __( 'Tab Count', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '01', 'mojito-core' ),
                'placeholder' => __( 'Type your count here', 'mojito-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => ['style_1', 'style_2'],
                ],
            ]
        );

        // tab_title
        $repeater->add_control(
            'tab_title',
            [
                'label'       => __( 'Tab Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Tab Title', 'mojito-core' ),
                'placeholder' => __( 'Type your title here', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // tab icon
        $repeater->add_control(
            'tab_icon',
            [
                'label'       => __( 'Tab Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
                'condition'   => [
                    'design_style' => 'style_2',
                ],
            ]
        );

        // tab_cat
        $repeater->add_control(
            'tab_cat',
            [
                'label'       => __( 'Tab Category', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Tab Category', 'mojito-core' ),
                'placeholder' => __( 'Type your category here', 'mojito-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        // tab_content
        $repeater->add_control(
            'tab_content',
            [
                'label'       => __( 'Tab Content', 'mojito-core' ),
                'type'        => Controls_Manager::WYSIWYG,
                'default'     => __( 'Tab Content', 'mojito-core' ),
                'placeholder' => __( 'Type your content here', 'mojito-core' ),
                'show_label'  => false,
                'condition'   => [
                    'design_style' => ['style_1', 'style_3'],
                ],
            ]
        );

        // tab_image_1
        $repeater->add_control(
            'tab_image_1',
            [
                'label'       => __( 'Tab Image 1', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition'   => [
                    'design_style' => ['style_1', 'style_2'],
                ],
            ]
        );

        // tab_image_2
        $repeater->add_control(
            'tab_image_2',
            [
                'label'       => __( 'Tab Image 2', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition'   => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        // button text
        $repeater->add_control(
            'button_text',
            [
                'label'       => __( 'Button Text', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Read More', 'mojito-core' ),
                'placeholder' => __( 'Type your button text here', 'mojito-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        // button link
        $repeater->add_control(
            'button_link',
            [
                'label'       => __( 'Button Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        // button icon
        $repeater->add_control(
            'button_icon',
            [
                'label'       => __( 'Button Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
                'condition'   => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        // enable service box
        $repeater->add_control(
            'enable_service_box_1',
            [
                'label'        => __( 'Enable Service Box', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => 'style_2',
                ],
            ]
        );

        // service box 1 image
        $repeater->add_control(
            'service_box_1_image',
            [
                'label'       => __( 'Service Box 1 Image', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition'   => [
                    'enable_service_box_1' => 'yes',
                ],
            ]
        );

        // service box 1 title
        $repeater->add_control(
            'service_box_1_title',
            [
                'label'       => __( 'Service Box 1 Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Service Box 1 Title', 'mojito-core' ),
                'placeholder' => __( 'Type your title here', 'mojito-core' ),
                'label_block' => true,
                'condition'   => [
                    'enable_service_box_1' => 'yes',
                ],
            ]
        );

        // service box 1 description
        $repeater->add_control(
            'service_box_1_description',
            [
                'label'       => __( 'Service Box 1 Description', 'mojito-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __( 'Service Box 1 Description', 'mojito-core' ),
                'placeholder' => __( 'Type your description here', 'mojito-core' ),
                'rows'        => 4,
                'condition'   => [
                    'enable_service_box_1' => 'yes',
                ],
            ]
        );

        // service box 1 button link
        $repeater->add_control(
            'service_box_1_button_link',
            [
                'label'       => __( 'Service Box 1 Button Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'label_block' => true,
                'condition'   => [
                    'enable_service_box_1' => 'yes',
                ],
            ]
        );

        // service box 1 icon
        $repeater->add_control(
            'service_box_1_button_icon',
            [
                'label'       => __( 'Service Box 1 Button Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
                'condition'   => [
                    'enable_service_box_1' => 'yes',
                ],
            ]
        );

        // enable service box 2
        $repeater->add_control(
            'enable_service_box_2',
            [
                'label'        => __( 'Enable Service Box 2', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => 'style_2',
                ],
            ]
        );

        // service box 2 image
        $repeater->add_control(
            'service_box_2_image',
            [
                'label'       => __( 'Service Box 2 Image', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition'   => [
                    'enable_service_box_2' => 'yes',
                ],
            ]
        );

        // service box 2 title
        $repeater->add_control(
            'service_box_2_title',
            [
                'label'       => __( 'Service Box 2 Title', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Service Box 2 Title', 'mojito-core' ),
                'placeholder' => __( 'Type your title here', 'mojito-core' ),
                'label_block' => true,
                'condition'   => [
                    'enable_service_box_2' => 'yes',
                ],
            ]
        );

        // service box 2 description
        $repeater->add_control(
            'service_box_2_description',
            [
                'label'       => __( 'Service Box 2 Description', 'mojito-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __( 'Service Box 2 Description', 'mojito-core' ),
                'placeholder' => __( 'Type your description here', 'mojito-core' ),
                'rows'        => 4,
                'condition'   => [
                    'enable_service_box_2' => 'yes',
                ],
            ]
        );

        // service box 2 button link
        $repeater->add_control(
            'service_box_2_button_link',
            [
                'label'       => __( 'Service Box 2 Button Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'mojito-core' ),
                'label_block' => true,
                'condition'   => [
                    'enable_service_box_2' => 'yes',
                ],
            ]
        );

        // service box 2 button icon
        $repeater->add_control(
            'service_box_2_button_icon',
            [
                'label'       => __( 'Service Box 2 Button Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
                'condition'   => [
                    'enable_service_box_2' => 'yes',
                ],
            ]
        );

        // short description
        $repeater->add_control(
            'feature_lists',
            [
                'label'       => __( 'Feature Lists', 'mojito-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __( 'Feature Lists', 'mojito-core' ),
                'placeholder' => __( 'Type your feature lists here', 'mojito-core' ),
                'rows'        => 4,
                'condition'   => [
                    'design_style' => 'style_3',
                ],
            ]
        );

        // lists items
        $this->add_control(
            'txTab_lists',
            [
                'label'  => __( 'Tabs', 'mojito-core' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();

        // SETTINGS
        $this->start_controls_section(
            '_section_settings',
            [
                'label'     => __( 'Settings', 'mojito-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
            ]
        );

        // enable_shape
        $this->add_control(
            'enable_shape',
            [
                'label'        => __( 'Enable Shape', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE SUB TITLE
        $this->add_control(
            'enable_sub_title',
            [
                'label'        => __( 'Enable Sub Title', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE TITLE
        $this->add_control(
            'enable_title',
            [
                'label'        => __( 'Enable Title', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE DESCRIPTION
        $this->add_control(
            'enable_description',
            [
                'label'        => __( 'Enable Description', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {

        $dir = dirname( __FILE__ );
        $style_files = glob( $dir . '/styles/*.php' );

        if ( $style_files ) {
            foreach ( $style_files as $style_file ) {
                include $style_file;
            }
        }

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty( $settings['design_style'] ) ? $settings['design_style'] : 'style_1';

        switch ( $style ) {
        case 'style_3':
            include $dir . '/views/view-3.php';
            break;
        case 'style_2':
            include $dir . '/views/view-2.php';
            break;
        default:
            include $dir . '/views/view-1.php';
        }
    }
}
