<div class="pf-services-4-area pt-100 pb-120 wa-p-relative tx-section">
	<?php if(!empty( $settings['image_1']['url'] )) : ?>
	<div class="pf-services-4-bg-shape-1">
		<img class="wa-translateY-0" src="<?php echo esc_url($settings['image_1']['url']); ?>"  alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_1']['url'] ); } ?>">
	</div>
	<?php endif; ?>

	<?php if(!empty( $settings['image_2']['url'] )) : ?>
	<div class="pf-services-4-bg-shape-2">
		<img class="wa-translateY-0" src="<?php echo esc_url($settings['image_2']['url']); ?>"  alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_2']['url'] ); } ?>">
	</div>
	<?php endif; ?>

	<div class="container pf-container-1">

		<!-- section-title -->
		<div class="pf-sec-shape pf-services-4-sec-shape">
			<?php if(!empty( $settings['image_3']['url'] )) : ?>
			<div class="pf-sec-shape-1" >
				<img src="<?php echo esc_url($settings['image_3']['url']); ?>"  alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_3']['url'] ); } ?>">
			</div>
			<?php endif; ?>

			<?php if(!empty( $settings['image_4']['url'] )) : ?>
			<div class="pf-sec-shape-2" >
				<img src="<?php echo esc_url($settings['image_4']['url']); ?>"  alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_4']['url'] ); } ?>">
			</div>
			<?php endif; ?>
		</div>

		<?php
			if($settings['enable_title'] === 'yes') {
			$this->add_render_attribute( 'title', 'class', 'tx-title pf-sec-title-3 pf-services-4-sec-title pf-split-2' );
				printf('<%1$s %2$s>%3$s</%1$s>',
					tag_escape($settings['title_tag']),
					$this->get_render_attribute_string('title'),
					elh_element_kses_basic( $settings['title'] )
				);
			}
		?>

		<div class="pf-services-4-wrap mb-40">
			<?php foreach($settings['service_slide_boxs'] as $list ) : ?>
			<div class="pf-services-4-card wow fadeInUp">
				<?php if( $list['enable_icon'] == true ) : ?>
				<div class="card-img wa-img-cover wa-fix">
					<?php if ( $list['type'] == 'icon' ): ?>
						<?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], ['aria-hidden' => 'true'] );?>
					<?php else: ?>
						<img src="<?php echo esc_url($list['info_image']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['info_image']['url']) : ''); ?>">
					<?php endif;?>
				</div>
				<?php endif; ?>

				<div class="card-content">
					<div class="left">
						<?php if(!empty( $list['title'] )) : ?>
						<h4 class="pf-h-1 card-title">
							<a
							href="<?php echo esc_url($list['button_link']['url']); ?>"
							target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
							rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
							aria-label="name">
								<?php echo elh_element_kses_intermediate( $list['title'] ); ?>
							</a>
						</h4>
						<?php endif; ?>

						<?php if(!empty( $list['description'] )) : ?>
						<p class="pf-p-2 card-disc">
							<?php echo elh_element_kses_intermediate( $list['description'] ); ?>
						</p>
						<?php endif; ?>
					</div>

					<a href="<?php echo esc_url($list['button_link']['url']); ?>"
					target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
					rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
					class="pf-arrow-btn">
						<?php if(!empty( $list['button_icon'] )) : ?>
						<span class="icon">
							<?php \Elementor\Icons_Manager::render_icon( $list['button_icon'], ['aria-hidden' => 'true'] );?>
							<?php \Elementor\Icons_Manager::render_icon( $list['button_icon'], ['aria-hidden' => 'true'] );?>
						</span>
						<?php endif; ?>
					</a>
				</div>
			</div>
			<?php endforeach; ?>
		</div>

		<!-- all-btn -->
		<?php if( $settings['enable_button'] === 'yes' ) : ?>
		<div class="pf-services-4-all-btn text-center wow fadeInUp">
			<a href="<?php echo esc_url($settings['button_link']['url']); ?>"
			target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
			rel= "<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>" aria-label="name" class="pf-pr-3 tx-button">
				<?php echo elh_element_kses_intermediate( $settings['button_text'] ); ?>

				<?php if( $settings['enable_button_icon'] === 'yes' ) : ?>
				<span class="icon">
					<?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], ['aria-hidden' => 'true'] ); ?>
				</span>
				<?php endif; ?>
			</a>
		</div>
		<?php endif; ?>
	</div>
</div>