<div class="pf-services-3-area pb-110 wa-p-relative tx-section">
	<div class="container pf-container-1">
		<!-- section-title -->
		<div class="pf-services-3-sec-title">

			<div class="pf-sec-shape">
				<?php if(!empty( $settings['image_1']['url'] )) : ?>
				<div class="pf-sec-shape-1">
					<div class="left-right">
						<img src="<?php echo esc_url($settings['image_1']['url']); ?>"  alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_1']['url'] ); } ?>">
					</div>
				</div>
				<?php endif; ?>

				<?php if(!empty( $settings['image_2']['url'] )) : ?>
				<div class="pf-sec-shape-2">
					<div class="left-right">
						<img src="<?php echo esc_url($settings['image_2']['url']); ?>"  alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_2']['url'] ); } ?>">
					</div>
				</div>
				<?php endif; ?>
			</div>

			<?php
                if($settings['enable_title'] === 'yes') {
                $this->add_render_attribute( 'title', 'class', 'tx-title pf-sec-title-3 pf-split-2' );
                    printf('<%1$s %2$s>%3$s</%1$s>',
                        tag_escape($settings['title_tag']),
                        $this->get_render_attribute_string('title'),
                        elh_element_kses_basic( $settings['title'] )
                    );
                }
            ?>
		</div>


		<!-- services-card -->
		<div class="pf-services-3-card wow fadeInUp">

			<?php foreach($settings['service_slide_boxs'] as $list ) : ?>
			<div class="pf-services-3-card-single">
				<?php if( $settings['enable_shape'] === 'yes' ) : ?>
				<svg class="card-shape" width="192" height="192" viewBox="0 0 192 192" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path class="card-shape-1" opacity="0.04" d="M0 0C0 106.057 85.9714 192 192 192V0H0Z" fill="#2A2A2A"/>
					<path class="card-shape-2" opacity="0.04" d="M64 0C64 70.7044 121.314 128 192 128V0H64Z" fill="#2A2A2A"/>
					<path class="card-shape-3" opacity="0.04" d="M128 0C128 35.3522 156.657 64 192 64V0H128Z" fill="#2A2A2A"/>
				</svg>
				<?php endif; ?>

				<?php if( $list['enable_icon'] == true ) : ?>
				<div class="icon">
					<?php if ( $list['type'] == 'icon' ): ?>
						<?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], ['aria-hidden' => 'true'] );?>
					<?php else: ?>
						<img src="<?php echo esc_url($list['info_image']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['info_image']['url']) : ''); ?>">
					<?php endif;?>
				</div>
				<?php endif; ?>

				<?php if(!empty( $list['title'] )) : ?>
				<h5 class="pf-h-1 card-title">
					<a
					href="<?php echo esc_url($list['button_link']['url']); ?>"
					target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
					rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
					aria-label="name">
						<?php echo elh_element_kses_intermediate( $list['title'] ); ?>
					</a>
				</h5>
				<?php endif; ?>
				<?php if(!empty( $list['description'] )) : ?>
				<p class="pf-p-2 card-disc"><?php echo elh_element_kses_intermediate( $list['description'] ); ?></p>
				<?php endif; ?>
			</div>
			<?php endforeach; ?>

		</div>
	</div>

	<?php if(!empty( $settings['image_3']['url'] )) : ?>
	<div class="pf-services-3-bg-shape-1">
		<img class="wa-translateY-0" src="<?php echo esc_url($settings['image_3']['url']); ?>"  alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_3']['url'] ); } ?>">
	</div>
	<?php endif; ?>

	<?php if(!empty( $settings['image_4']['url'] )) : ?>
	<div class="pf-services-3-bg-shape-2">
		<img class="wa-translateY-0" src="<?php echo esc_url($settings['image_4']['url']); ?>"  alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_4']['url'] ); } ?>">
	</div>
	<?php endif; ?>
</div>