<div class="pf-multi-sec-1 wa-p-relative pt-145 pb-150 pf-mlr-12 wa-bg-default wa-fix" data-background="<?php echo esc_url($settings['image_1']['url']) ? esc_url($settings['image_1']['url']) : ''; ?>">

    <?php if(!empty( $settings['image_2']['url'] )) : ?>
    <img class="illus-1" src="<?php echo esc_url($settings['image_2']['url']); ?>"  alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_2']['url'] ); } ?>">
    <?php endif; ?>

    <?php if(!empty( $settings['image_3']['url'] )) : ?>
    <img class="illus-2" src="<?php echo esc_url($settings['image_3']['url']); ?>"  alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_3']['url'] ); } ?>">
    <?php endif; ?>

    <!-- services-start -->
    <div class="pf-services-2-area">
        <div class="container pf-container-1">
            <?php
                if($settings['enable_title'] === 'yes') {
                $this->add_render_attribute( 'title', 'class', 'tx-title pf-services-2-sec-title pf-sec-title-2 has-clr-white pf-split-2' );
                    printf('<%1$s %2$s>%3$s</%1$s>',
                        tag_escape($settings['title_tag']),
                        $this->get_render_attribute_string('title'),
                        elh_element_kses_basic( $settings['title'] )
                    );
                }
            ?>

            <!-- content -->
            <div class="pf-services-2-wrap wa-fix">

                <!-- left-btn -->
                <?php if( $settings['enable_button'] === 'yes' ) : ?>
                <div class="pf-services-2-btn">
                    <a href="<?php echo esc_url($settings['button_link']['url']); ?>"
                    target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                    rel= "<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
                    aria-label="name"
                    class="pf-pr-2 has-border tx-button">
                        <?php if(!empty( $settings['button_text'] )) : ?>
                        <span class="text"
                            data-back="<?php echo esc_attr( $settings['button_text'] ); ?>"
                            data-front="<?php echo esc_attr( $settings['button_text'] ); ?>">
                        </span>
                        <?php endif; ?>

                        <?php if(!empty( $settings['button_icon'] )) : ?>
                        <span class="icon">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], ['aria-hidden' => 'true'] ); ?>
                            <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], ['aria-hidden' => 'true'] ); ?>
                        </span>
                        <?php endif; ?>
                    </a>
                </div>
                <?php endif; ?>

                <!-- slider -->
                <div class="pf-services-2-slider wa-fix wa-p-relative ">

                    <!-- slider -->
                    <div class="swiper-container pf-s2-slider">
                        <div class="swiper-wrapper">

                            <?php foreach($settings['service_slide_boxs'] as $list ) : ?>
                            <div class="swiper-slide">
                                <div class="pf-services-2-slider-item">
                                    <?php if(!empty( $list['cat_name'] )) : ?>
                                    <h5 class="pf-h-1 subtitle"><?php echo elh_element_kses_intermediate( $list['cat_name'] ); ?></h5>
                                    <?php endif; ?>

                                    <?php if( $list['enable_icon'] == true ) : ?>
                                    <div class="item-img wa-fix wa-img-cover">
                                        <?php if ( $list['type'] == 'icon' ): ?>
                                            <?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], ['aria-hidden' => 'true'] );?>
                                        <?php else: ?>
                                            <img src="<?php echo esc_url($list['info_image']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['info_image']['url']) : ''); ?>">
                                        <?php endif;?>
                                    </div>
                                    <?php endif; ?>

                                    <div class="content">
                                        <?php if(!empty( $list['title'] )) : ?>
                                        <h4 class="pf-h-1 item-title">
                                            <a
                                            href="<?php echo esc_url($list['button_link']['url']); ?>"
                                            target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                            rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
                                            aria-label="name">
                                                <?php echo elh_element_kses_intermediate( $list['title'] ); ?>
                                            </a>
                                        </h4>
                                        <?php endif; ?>

                                        <?php if(!empty( $list['description'] )) : ?>
                                        <p class="pf-p-1 item-disc"><?php echo elh_element_kses_intermediate( $list['description'] ); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <?php if( $settings['enable_navigation'] === 'yes' ) : ?>
                    <div class="pf-services-2-slider-btn pf-slider-hori-btn">
                        <div class="pf-slider-hori-btn-single pf-s2-btn-next">
                            <i class="fa-solid fa-chevron-right"></i>
                        </div>
                        <div class="pf-slider-hori-btn-single pf-s2-btn-prev">
                            <i class="fa-solid fa-chevron-left"></i>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?php if( $settings['enable_pagination'] === 'yes' ) : ?>
                    <div class="pf-s2-pagination-num"></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <!-- services-end -->

    <!-- video-start -->
    <?php if(!empty( $settings['enable_video_box'] )) : ?>
    <div class="pf-video-2-area pt-150">
        <div class="container pf-container-1">
            <?php if(!empty( $settings['video_sub_heading'] )) : ?>
            <h6 class="pf-video-2-sec-subtitle"><?php echo elh_element_kses_intermediate( $settings['video_sub_heading'] ); ?></h6>
            <?php endif; ?>

            <?php if(!empty( $settings['video_description'] )) : ?>
            <p class="pf-video-2-sec-title pf-sec-title-2 has-clr-white pf-video-2-split">
                <?php echo elh_element_kses_intermediate( $settings['video_description'] ); ?>
            </p>
            <?php endif; ?>

            <div class="pf-video-2 has-video-ani">
                <?php if(!empty( $settings['video_image']['url'] )) : ?>
                <div class="pf-video-2-img wa-fix wa-img-cover">
                    <img src="<?php echo esc_url($settings['video_image']['url']); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['video_image']['url'] ); } ?>">
                </div>
                <?php endif; ?>

                <?php if(!empty( $settings['video_link']['url'] )) : ?>
                <div class="pf-video-2-btn has-video-ani-elm">
                    <a href="<?php echo esc_url($settings['video_link']['url']); ?>" aria-label="name" class="pf-video-btn-1 popup-video">
                        <i class="fa-solid fa-play"></i>
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>