<section class="mt-portfolio-section-2 pt-120 pb-120 tx-section">
    <div class="mt-portfolio-content-2 d-flex justify-content-end">
        <div class="mt-portfolio-wrap">
            <div class="mt-portfolio-top d-flex align-items-center justify-content-between">
                <div class="mt-section-title mt-text ver_2 headline">
                    <?php if(!empty( $settings['sub_title'] )) : ?>
                    <div class="subtitle-2 wow fadeInRight"  data-wow-delay="400ms" data-wow-duration="1000ms">
                        <?php echo elh_element_kses_intermediate( $settings['sub_title'] ); ?>
                    </div>
                    <?php endif; ?>

                    <?php
                        if($settings['enable_title'] === 'yes') {
                        $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                            printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                elh_element_kses_basic( $settings['title'] )
                            );
                        }
                    ?>
                <?php if( $settings['enable_description'] === 'yes' ) : ?>
                <p class="tx-description">
                    <?php echo elh_element_kses_intermediate( $settings['description'] ); ?>
                </p>
                <?php endif; ?>
                </div>
                <div class="mt-portfolio-item-wrap d-flex">
                    <?php
                        foreach ($settings['service_slide_boxs'] as $index => $list) :
                    ?>
                    <div class="mt-portfolio-item-2 position-relative wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                        <?php if( $list['enable_icon'] == true ) : ?>
                        <div class="item-img">
                            <?php if ( $list['type'] == 'icon' ): ?>
                                <?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], ['aria-hidden' => 'true'] );?>
                            <?php else: ?>
                                <img src="<?php echo esc_url($list['info_image']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['info_image']['url']) : ''); ?>">
                            <?php endif;?>
                        </div>
                        <?php endif; ?>
                        <div class="item-text headline">
                            <?php if(!empty( $list['cat_name'] )) : ?>
                            <span><?php echo esc_html($list['cat_name']); ?></span>
                            <?php endif; ?>

                            <?php if(!empty( $list['title'] )) : ?>
                            <h3 class="project_title href-underline">
                                <a
                                href="<?php echo esc_url($list['button_link']['url']); ?>"
                                target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
                                aria-label="name">
                                    <?php echo elh_element_kses_intermediate( $list['title'] ); ?>
                                </a>
                            </h3>
                            <?php endif; ?>

                            <?php if(!empty( $list['button_icon'] )) : ?>
                            <a class="item_arrow d-flex justify-content-center align-items-center position-absolute"
                                href="<?php echo esc_url($list['button_link']['url']); ?>"
                                target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                                <?php \Elementor\Icons_Manager::render_icon( $list['button_icon'], ['aria-hidden' => 'true'] );?>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="mt-portfolio-bottom mt-30">
                <div class="mt-portfolio-item-wrap d-flex">
                    <?php
                        foreach ($settings['service_slide_boxs_2'] as $index => $list) :
                    ?>
                    <div class="mt-portfolio-item-2 position-relative wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
                        <?php if( $list['enable_icon'] == true ) : ?>
                        <div class="item-img">
                            <?php if ( $list['type'] == 'icon' ): ?>
                                <?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], ['aria-hidden' => 'true'] );?>
                            <?php else: ?>
                                <img src="<?php echo esc_url($list['info_image']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['info_image']['url']) : ''); ?>">
                            <?php endif;?>
                        </div>
                        <?php endif; ?>
                        <div class="item-text headline">
                            <?php if(!empty( $list['cat_name'] )) : ?>
                            <span><?php echo esc_html($list['cat_name']); ?></span>
                            <?php endif; ?>

                            <?php if(!empty( $list['title'] )) : ?>
                            <h3 class="project_title href-underline">
                                <a
                                href="<?php echo esc_url($list['button_link']['url']); ?>"
                                target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
                                aria-label="name">
                                    <?php echo elh_element_kses_intermediate( $list['title'] ); ?>
                                </a>
                            </h3>
                            <?php endif; ?>

                            <?php if(!empty( $list['button_icon'] )) : ?>
                            <a class="item_arrow d-flex justify-content-center align-items-center position-absolute"
                                href="<?php echo esc_url($list['button_link']['url']); ?>"
                                target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                                <?php \Elementor\Icons_Manager::render_icon( $list['button_icon'], ['aria-hidden' => 'true'] );?>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>