<section class="mt-feature-section pt-145 pb-120 tx-section">
    <div class="container mt-container-1">
        <div class="mt-section-title ver_2 headline text-center">
            <?php if(!empty( $settings['sub_title'] )) : ?>
            <div class="subtitle-2 wow fadeInRight tx-subTitle"  data-wow-delay="400ms" data-wow-duration="1000ms">
                <?php echo elh_element_kses_intermediate( $settings['sub_title'] ); ?>
            </div>
            <?php endif; ?>
            <?php
                if($settings['enable_title'] === 'yes') {
                $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                    printf('<%1$s %2$s>%3$s</%1$s>',
                        tag_escape($settings['title_tag']),
                        $this->get_render_attribute_string('title'),
                        elh_element_kses_basic( $settings['title'] )
                    );
                }
            ?>
        </div>
        <div class="mt-feature-content d-flex pt-45">
            <div class="mt-feature-img">
                <?php if(!empty( $settings['image_1']['url'] )) : ?>
                <div class="item-img txt_item_active">
                    <img
                    src="<?php echo esc_url($settings['image_1']['url']); ?>"
                    alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_1']['url']) : ''); ?>">
                </div>
                <?php endif; ?>
                <div class="item-text mt-25 ul-li wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">

                    <?php if( $settings['enable_feature_lists'] === 'yes' ) : ?>
                    <ul>
                        <?php foreach ($settings['feature_lists'] as $index => $list) : ?>
                        <li>
                            <?php \Elementor\Icons_Manager::render_icon( $list['feature_icon'], ['aria-hidden' => 'true'] );?>
                            <?php echo elh_element_kses_intermediate( $list['feature_text'] ); ?>
                        </li>
                    <?php endforeach; ?>
                    </ul>
                    <?php endif; ?>

                    <?php if( $settings['enable_button'] === 'yes' ) : ?>
                    <div class="mt-btn-3 mt-20 ver_2 text-uppercase">
                        <a class="tx-button" href="<?php echo esc_url($settings['button_link']['url']); ?>"
                        target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                        rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                            <?php echo esc_html($settings['button_text']); ?>
                            <?php
                                if(!empty( $settings['enable_button_icon'] === 'yes') ) {
                                    \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );
                                }
                            ?>
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="mt-feature-text headline pera-content mt-text">
                <?php if( $settings['enable_description'] === 'yes' ) : ?>
                <p>
                    <?php echo elh_element_kses_intermediate( $settings['description'] ); ?>
                </p>
                <?php endif; ?>
                <div class="mt-feature-item-wrap mt-10">
                    <?php
                        foreach ($settings['service_slide_boxs'] as $index => $list) :
                    ?>
                    <div class="mt-feature-item txt_item_active d-flex flex-wrap headline pera-content position-relative wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
                        <?php if( $list['enable_icon'] == true ) : ?>
                        <div class="item-icon">
                            <?php if ( $list['type'] == 'icon' ): ?>
                                <?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], ['aria-hidden' => 'true'] );?>
                            <?php else: ?>
                                <img src="<?php echo esc_url($list['info_image']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['info_image']['url']) : ''); ?>">
                            <?php endif;?>
                        </div>
                        <?php endif; ?>
                        <div class="item-text headline pera-content">
                            <h3>
                            <a
                                href="<?php echo esc_url($list['button_link']['url']); ?>"
                                target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
                                aria-label="name">
                                    <?php echo elh_element_kses_intermediate( $list['title'] ); ?>
                                </a>
                            </h3>
                            <?php if(!empty( $list['description'] )) : ?>
                            <p><?php echo elh_element_kses_intermediate( $list['description'] ); ?></p>
                            <?php endif; ?>
                        </div>

                        <?php if(!empty( $list['button_icon'] )) : ?>
                        <div class="icon-arrow">
                            <?php \Elementor\Icons_Manager::render_icon( $list['button_icon'], ['aria-hidden' => 'true'] );?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>