<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;

// section padding
$this->start_controls_section(
    '_section_service_style_box',
    [
        'label' => __( 'BOX STYLE', 'gilroy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// box bg color
$this->add_control(
    'service_box_bg_color',
    [
        'label'     => __( 'Background Color', 'gilroy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pf-services-4-card' => 'background-color: {{VALUE}};',
        ],
    ]
);

// box hover bg color
$this->add_control(
    'service_box_hover_bg_color',
    [
        'label'     => __( 'Hover Background Color', 'gilroy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pf-services-4-card:hover' => 'background-color: {{VALUE}};',
        ],
    ]
);

// button icon color
$this->add_control(
    'service_box_icon_color',
    [
        'label'     => __( 'Icon Color', 'gilroy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pf-arrow-btn' => 'stroke: {{VALUE}};',
        ],
    ]
);

// icon border color
$this->add_control(
    'service_box_icon_border_color',
    [
        'label'     => __( 'Icon Border Color', 'gilroy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pf-arrow-btn' => 'border-color: {{VALUE}};',
        ],
    ]
);

// button border color
$this->add_control(
    'service_box_icon_bg_color',
    [
        'label'     => __( 'Icon Background Color', 'gilroy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pf-arrow-btn' => 'background-color: {{VALUE}};',
        ],
    ]
);

// button hover bg color
$this->add_control(
    'service_box_icon_hover_bg_color',
    [
        'label'     => __( 'Hover Icon Background Color', 'gilroy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pf-arrow-btn:hover' => 'background-color: {{VALUE}};',
        ],
    ]
);

// button hover icon color
$this->add_control(
    'service_box_icon_hover_color',
    [
        'label'     => __( 'Hover Icon Color', 'gilroy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .pf-arrow-btn:hover' => 'color: {{VALUE}};',
        ],
    ]
);

// end
$this->end_controls_section();