<div class="mt-ser-detail-feed-content text-center">
    <?php foreach($settings['service_lists'] as $list ) : ?>
    <div class="mt-ser-detail-feed-item position-relative">
        <?php if(!empty( $list['image_1']['url'] )) : ?>
        <div class="item-img">
            <img src="<?php echo esc_url($list['image_1']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['image_1']['url']) : ''); ?>">
        </div>
        <?php endif; ?>

        <div class="item-text text-center">
            <?php if( $list['enable_icon'] == true ) : ?>
            <div class="inner-icon d-flex align-items-center justify-content-center">
                <?php if ( $list['type'] == 'icon' ): ?>
                    <?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], ['aria-hidden' => 'true'] );?>
                <?php else: ?>
                    <img src="<?php echo esc_url($list['info_image']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['info_image']['url']) : ''); ?>">
                <?php endif;?>
            </div>
            <?php endif; ?>

            <div class="inner-text headline pera-content">
                <?php if(!empty( $list['title'] )) : ?>
                <h3 class="href-underline">
                    <a
                        href="<?php echo esc_url($list['button_link']['url']); ?>"
                        target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                        rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
                        aria-label="name">
                        <?php echo elh_element_kses_intermediate( $list['title'] ); ?>
                    </a>
                </h3>
                <?php endif; ?>

                <?php if(!empty( $list['description'] )) : ?>
                <p>
                    <?php echo elh_element_kses_intermediate( $list['description'] ); ?>
                </p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>