<div class="mt-portfolio-content-3 position-relative">
    <div class="mt-portfolio-slider-3 swiper-container">
        <div class="swiper-wrapper">
            <?php foreach($settings['service_lists'] as $list ) : ?>
            <div class="swiper-slide">
                <div class="mt-portfolio-item-3 position-relative">
                    <?php if(!empty( $settings['image_1']['url'] )) : ?>
                    <span class="port-shape position-absolute">
                        <img src="<?php echo esc_url($settings['image_1']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($settings['image_1']['url']) : ''); ?>">
                    </span>
                    <?php endif; ?>

                    <?php if( $list['enable_icon'] == true ) : ?>
                    <div class="item-img">
                        <?php if ( $list['type'] == 'icon' ): ?>
                            <?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], ['aria-hidden' => 'true'] );?>
                        <?php else: ?>
                            <img src="<?php echo esc_url($list['info_image']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['info_image']['url']) : ''); ?>">
                        <?php endif;?>
                    </div>
                    <?php endif; ?>
                    <div class="item-text headline">
                        <?php if(!empty( $list['cat_name'] )) : ?>
                        <span class="port-cate text-uppercase">
                            <a
                                href="<?php echo esc_url($list['button_link']['url']); ?>"
                                target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
                                aria-label="name">
                                <?php echo elh_element_kses_intermediate( $list['cat_name'] ); ?>
                            </a>
                        </span>
                        <?php endif; ?>

                        <?php if(!empty( $list['title'] )) : ?>
                        <h3 class="port_title text-uppercase">
                            <a
                                href="<?php echo esc_url($list['button_link']['url']); ?>"
                                target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
                                aria-label="name">
                                <span><?php echo elh_element_kses_intermediate( $list['title'] ); ?></span>
                                <?php \Elementor\Icons_Manager::render_icon( $list['button_icon'], ['aria-hidden' => 'true'] );?>
                            </a>
                        </h3>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php if( $settings['enable_slider_nav'] === 'yes' ) : ?>
    <div class="mt-portfolio-slider-nav  d-flex align-items-center ">
        <div class="mt-port-prev d-flex align-items-center justify-content-center"><i class="fas fa-chevron-left"></i></div>
        <div class="mt-port-next d-flex align-items-center justify-content-center"><i class="fas fa-chevron-right"></i></div>
    </div>
    <?php endif; ?>
</div>