<section class="mt-portfolio-section pt-120 pb-120 position-relative tx-section">
    <?php if(!empty( $settings['big_title'] )) : ?>
    <div class="title-text-bg appear_top">
        <?php echo elh_element_kses_intermediate($settings['big_title']); ?>
    </div>
    <?php endif; ?>
    <div class="mt-portfolio-content">
        <?php if( $settings['enable_slider_nav'] === 'yes' ) : ?>
        <div class="mt-portfolio-nav-arrow d-flex justify-content-end">
            <div class="mt-port-nav d-flex">
                <div class="mt-port-prev d-flex align-items-center justify-content-center"><i class="fas fa-long-arrow-left"></i></div>
                <div class="mt-port-next d-flex align-items-center justify-content-center"><i class="fas fa-long-arrow-right"></i></div>
            </div>
        </div>
        <?php endif; ?>
        <div class="mt-portfolio-slider swiper-container">
            <div class="swiper-wrapper">
            <?php foreach($settings['service_lists'] as $list ) : ?>
                <div class="swiper-slide">
                    <div class="mt-portfolio-item">
                        <?php if( $list['enable_icon'] == true ) : ?>
                        <div class="item-img">
                            <?php if ( $list['type'] == 'icon' ): ?>
                                <?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], ['aria-hidden' => 'true'] );?>
                            <?php else: ?>
                                <img src="<?php echo esc_url($list['info_image']['url']); ?>" alt="<?php echo esc_attr(function_exists('mojito_img_alt_text') ? mojito_img_alt_text($list['info_image']['url']) : ''); ?>">
                            <?php endif;?>
                        </div>
                        <?php endif; ?>

                        <div class="item-text headline">
                            <?php if(!empty( $list['title'] )) : ?>
                            <h3 class="project_title">
                                <a
                                href="<?php echo esc_url($list['button_link']['url']); ?>"
                                target="<?php echo esc_attr($list['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                                rel= "<?php echo esc_attr($list['button_link']['nofollow'] ? 'nofollow' : ''); ?>"
                                aria-label="name">
                                    <?php echo elh_element_kses_intermediate( $list['title'] ); ?>
                                </a>
                            </h3>
                            <?php endif; ?>

                            <?php if( $list['enable_tags'] === 'yes' ) : ?>
                            <div class="port_cate">
                                <?php foreach($list['tag_lists'] as $_list) : ?>
                                <a href="<?php echo esc_url($_list['tag_link']['url']); ?>"
                                target="<?php echo esc_attr($_list['tag_link']['is_external'] ? '_blank' : '_self'); ?>"
                                rel= "<?php echo esc_attr($_list['tag_link']['nofollow'] ? 'nofollow' : ''); ?>">
                                    <?php echo esc_html($_list['tag_name']); ?>
                                </a>
                                <?php endforeach; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>