<section class="mt-pricing-section pt-120 pb-120 tx-section fix" data-background="<?php echo esc_url($settings['image_1']['url']) ? esc_url($settings['image_1']['url']) : ''; ?>">

    <?php if(!empty( $settings['image_2']['url'] )) : ?>
    <span class="price-shape position-absolute txt_item_active">
        <img src="<?php echo esc_url($settings['image_2']['url']); ?>"
        alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['image_2']['url'] ); } ?>">
    </span>
    <?php endif; ?>

    <div class="container mt-container-1">
        <div class="mt-section-title ver_2 headline text-center">
            <?php if(!empty( $settings['sub_title'] )) : ?>
            <div class="subtitle-2 wow fadeInRight" data-wow-delay="400ms" data-wow-duration="1000ms">
                <?php echo elh_element_kses_intermediate( $settings['sub_title'] ); ?>
            </div>
            <?php endif; ?>
            <?php
                if($settings['enable_title'] === 'yes') {
                $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                    printf('<%1$s %2$s>%3$s</%1$s>',
                        tag_escape($settings['title_tag']),
                        $this->get_render_attribute_string('title'),
                        elh_element_kses_basic( $settings['title'] )
                    );
                }
            ?>
        </div>

        <?php if( $settings['enable_pricing_box'] === 'yes' ) : ?>
        <div class="mt-pricing-content pt-65">
            <?php
                $i = 1;
                foreach( $settings['pricing_boxs'] as $list ) :
                if ($list['currency'] === 'custom') {
                    $currency = $list['currency_custom'];
                } else {
                    $currency = self::get_currency_symbol($list['currency']);
                }
            ?>
            <div class="mt-price-item d-flex align-items-center justify-content-between position-relative wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1000ms">
                <div class="item-serial-title d-flex align-items-center">
                    <?php if(!empty( $list['count'] )) : ?>
                    <div class="item-serial d-flex justify-content-center align-items-center">
                        <?php echo esc_html($list['count']); ?>
                    </div>
                    <?php endif; ?>
                    <?php if(!empty( $list['pricing_title'] )) : ?>
                    <div class="item-text">
                        <?php echo elh_element_kses_intermediate( $list['pricing_title']); ?>
                    </div>
                    <?php endif; ?>
                </div>

                <?php if(!empty( $list['image_1']['url'] )) : ?>
                <div class="item-img-view position-absolute">
                    <img src="<?php echo esc_url($list['image_1']['url']); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $list['image_1']['url'] ); } ?>">
                </div>
                <?php endif; ?>

                <div class="item-desc headline pera-content">
                    <h3><?php echo esc_html($currency . $list['price']); ?></h3>
                    <?php if(!empty( $list['pricing_description'] )) : ?>
                    <p><?php echo elh_element_kses_intermediate( $list['pricing_description'] ); ?></p>
                    <?php endif; ?>
                </div>

                <?php if(!empty( $list['image_2']['url'] )) : ?>
                <div class="item-img-hover position-absolute">
                    <img src="<?php echo esc_url($list['image_2']['url']); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $list['image_2']['url'] ); } ?>">
                </div>
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</section>