<section class="mt-blog-section-4">
    <div class="container mt-container-1">
        <div class="mt-blog-content-4">
            <div class="row">
                <?php
                    if (!empty($posts)):
                    foreach ( $posts as $inx => $post ) :
                    $title = $post->post_title;

                    if ( 'selected' === $settings['show_post_by'] && array_key_exists( $post->ID, $customize_title ) ) {
                        $title = $customize_title[$post->ID];
                    }

                    $excerpt = $post->post_excerpt;
                    if ( 'selected' === $settings['show_post_by'] && array_key_exists( $post->ID, $customize_text ) ) {
                        $excerpt = $customize_text[$post->ID];
                    }

                    $thumb = get_the_post_thumbnail_url( $post->ID, 'large' );
                    if ( 'selected' === $settings['show_post_by'] && array_key_exists( $post->ID, $customize_img ) && !empty( $customize_img[$post->ID]['url'] ) ) {
                        $thumb = $customize_img[$post->ID]['url'];
                    }

                    $author_name = get_the_author_meta( 'display_name', $post->post_author );
                    // aythor image
                    $author_img = get_avatar_url( $post->post_author, array( 'size' => 50 ) );

                    // get post categories
                    $categories = get_the_category( $post->ID );
                    $cat_name = '';

                    if ( !empty( $categories ) ) {
                        $cat_name = $categories[0]->name;
                        $cat_link = get_category_link( $categories[0]->term_id );
                    }
                    $post_by_label = $settings['post_by_label'];

                    $count = $inx + 1;
                ?>
                <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">
                    <div class="mt-blog-item-4">
                        <?php if(!empty( $thumb && $settings['feature_image'] === 'yes' )) : ?>
                        <div class="item-img">
                            <img src="<?php echo esc_url($thumb); ?>"
                            alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text($thumb); } ?>">
                        </div>
                        <?php endif; ?>
                        <div class="item-text headline pera-content">
                            <span class="item_cate">
                                <a href="<?php echo esc_url($cat_link); ?>">
                                    <?php echo esc_html($cat_name); ?>
                                </a>
                            </span>
                            <h3 class="blog_title href-underline">
                                <a href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>">
                                    <?php echo esc_html($title); ?>
                                </a>
                            </h3>
                            <div class="blog-mata">
                                <?php if ( 'yes' === $settings['meta'] && 'yes' === $settings['author_meta'] ): ?>
                                <a href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>"><i class="fas fa-user"></i>
                                    <?php echo esc_html($settings['post_by_label'] . ' ' . $author_name); ?>
                                </a>
                                <?php endif; ?>

                                <?php if ( 'yes' === $settings['meta'] && 'yes' === $settings['date_meta'] ): ?>
                                <a href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>">
                                    <i class="fas fa-calendar-alt"></i>
                                    <?php echo esc_html( get_the_date( get_option( 'date_format' ), $post->ID ) ); ?>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach;
                    $count++;
                    else:
                        printf('%1$s %2$s %3$s',
                            __('No ', 'mojito-core'),
                            esc_html($settings['post_type']),
                            __('Found', 'mojito-core')
                        );
                    endif;
                ?>
            </div>
        </div>
    </div>
</section>