<section class="mt-blog-section pt-120 pb-120 tx-section">
    <div class="container mt-container-1">
        <div class="mt-blog-content d-flex justify-content-center">
            <div class="mt-blog-text-area pt-20">
                <div class="mt-section-title mt-text headline pera-content">

                    <?php if(!empty( $settings['sub_title'] )) : ?>
                    <div class="subtitle wow fadeInRight" data-wow-delay="400ms" data-wow-duration="1000ms">
                        <?php echo elh_element_kses_intermediate( $settings['sub_title'] ); ?>
                    </div>
                    <?php endif; ?>

                    <?php
                        if($settings['enable_title'] === 'yes') {
                        $this->add_render_attribute( 'title', 'class', 'tx-title sec_title title_text title_text_ani' );
                            printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                elh_element_kses_basic( $settings['title'] )
                            );
                        }
                    ?>
                    <?php if( $settings['enable_description'] === 'yes' ) : ?>
                    <p>
                        <?php echo elh_element_kses_intermediate( $settings['description'] ); ?>
                    </p>
                    <?php endif; ?>
                </div>
                <?php if( $settings['enable_button'] === 'yes' ) : ?>
                <div class="mt-btn-3 mt-30 text-uppercase">
                    <a class="pf-pr-1 tx-button" href="<?php echo esc_url($settings['button_link']['url']); ?>"
                    target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                    rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                        <?php
                            echo elh_element_kses_intermediate( $settings['button_text'] );
                            if($settings['enable_button_icon'] === 'yes') {
                                \Elementor\Icons_Manager::render_icon( $settings['button_icon'], ['aria-hidden' => 'true'] );
                            }
                        ?>
                    </a>
                </div>
                <?php endif; ?>
            </div>
            <div class="mt-blog-item-content d-flex">
                <?php
                    if (!empty($posts)):
                    foreach ( $posts as $inx => $post ) :
                    $title = $post->post_title;

                    if ( 'selected' === $settings['show_post_by'] && array_key_exists( $post->ID, $customize_title ) ) {
                        $title = $customize_title[$post->ID];
                    }

                    $excerpt = $post->post_excerpt;
                    if ( 'selected' === $settings['show_post_by'] && array_key_exists( $post->ID, $customize_text ) ) {
                        $excerpt = $customize_text[$post->ID];
                    }

                    $thumb = get_the_post_thumbnail_url( $post->ID, 'large' );
                    if ( 'selected' === $settings['show_post_by'] && array_key_exists( $post->ID, $customize_img ) && !empty( $customize_img[$post->ID]['url'] ) ) {
                        $thumb = $customize_img[$post->ID]['url'];
                    }

                    $author_name = get_the_author_meta( 'display_name', $post->post_author );
                    // aythor image
                    $author_img = get_avatar_url( $post->post_author, array( 'size' => 50 ) );

                    // get post categories
                    $categories = get_the_category( $post->ID );
                    $cat_name = '';

                    if ( !empty( $categories ) ) {
                        $cat_name = $categories[0]->name;
                        $cat_link = get_category_link( $categories[0]->term_id );
                    }
                    $post_by_label = $settings['post_by_label'];

                    $count = $inx + 1;
                ?>
                <div class="mt-blog-item">
                    <div class="item-img-meta position-relative">
                        <?php if(!empty( $thumb && $settings['feature_image'] === 'yes' )) : ?>
                        <div class="item-img">
                            <img src="<?php echo esc_url($thumb); ?>"
                            alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text($thumb); } ?>">
                        </div>
                        <?php endif; ?>

                        <?php if ( 'yes' === $settings['meta'] && 'yes' === $settings['date_meta'] ): ?>
                        <div class="item-meta">
                            <?php echo esc_html( get_the_date( get_option( 'date_format' ), $post->ID ) ); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="item-text headline pera-content">
                        <h3 class="blog_title href-underline">
                            <a href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>">
                                <?php echo esc_html($title); ?>
                            </a>
                        </h3>
                        <p>
                            <?php echo esc_html($excerpt); ?>
                        </p>
                    </div>
                </div>
                <?php endforeach;
                    $count++;
                    else:
                        printf('%1$s %2$s %3$s',
                            __('No ', 'mojito-core'),
                            esc_html($settings['post_type']),
                            __('Found', 'mojito-core')
                        );
                    endif;
                ?>
            </div>
        </div>
    </div>
</section>