<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;

// section padding
$this->start_controls_section(
    '_section_post_style',
    [
        'label' => __( 'POST STYLE', 'gilroy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// title color
$this->add_control(
    'post_title_color',
    [
        'label'     => __( 'Title Color', 'gilroy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .item-title a' => 'color: {{VALUE}};',
        ],
    ]
);

// ty[ography]
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'post_title_typography',
        'label'    => __( 'Typography', 'gilroy-core' ),
        'selector' => '{{WRAPPER}} .item-title a',
    ]
);

// title hover color
$this->add_control(
    'post_title_hover_color',
    [
        'label'     => __( 'Title Hover Color', 'gilroy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .item-title:hover a' => 'color: {{VALUE}};',
        ],
    ]
);

// cat meta text color
$this->add_control(
    'post_cat_color',
    [
        'label'     => __( 'Category Color', 'gilroy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .item-meta a' => 'color: {{VALUE}};',
        ],
    ]
);

// cat meta typography
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'post_cat_typography',
        'label'    => __( 'Typography', 'gilroy-core' ),
        'selector' => '{{WRAPPER}} .item-meta a',
    ]
);

// cat meta bg color
$this->add_control(
    'post_cat_bg_color',
    [
        'label'     => __( 'Category Background Color', 'gilroy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .item-meta a' => 'background-color: {{VALUE}};',
        ],
    ]
);

// cat meta bg hover color
$this->add_control(
    'post_cat_bg_hover_color',
    [
        'label'     => __( 'Category Background Hover Color', 'gilroy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .item-meta:hover a' => 'background-color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_section();