<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;

defined( 'ABSPATH' ) || die();

class Tx_Link_Lists extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Element Helper widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_link_lists';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Lists Link', 'mojito-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['btn', 'lists', 'info', 'info lists'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                    'style_2' => __( 'Style 2', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_list_items',
            [
                'label' => __( 'List Items', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // heading
        $this->add_control(
            'info_heading',
            [
                'label'       => __( 'Info Heading', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Heading', 'mojito-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => 'style_10',
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        // design style
        $repeater->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'mojito-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'mojito-core' ),
                    'style_2' => __( 'Style 2', 'mojito-core' ),
                    'style_3' => __( 'Style 3', 'mojito-core' ),
                    'style_4' => __( 'Style 4', 'mojito-core' ),
                    'style_5' => __( 'Style 5', 'mojito-core' ),
                    'style_6' => __( 'Style 6', 'mojito-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // enable_icon
        $repeater->add_control(
            'enable_icon',
            [
                'label'        => __( 'Enable Icon', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $repeater->add_control(
            'type',
            [
                'label'          => __( 'List Icon', 'mojito-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'icon'  => [
                        'title' => __( 'Icon', 'mojito-core' ),
                        'icon'  => 'far fa-smile',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'mojito-core' ),
                        'icon'  => 'fa fa-image',
                    ],
                ],
                'default'        => 'icon',
                'toggle'         => false,
                'style_transfer' => true,
                'condition'      => [
                    'enable_icon' => 'yes',
                ],
            ]
        );

        // list icon
        $repeater->add_control(
            'list_icon',
            [
                'label'       => __( 'Icon', 'mojito-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'solid',
                ],
                'label_block' => true,
                'condition'   => [
                    'type'        => 'icon',
                    'enable_icon' => 'yes',
                ],
            ]
        );

        // list image
        $repeater->add_control(
            'list_image',
            [
                'label'       => __( 'Image', 'mojito-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition'   => [
                    'type'        => 'image',
                    'enable_icon' => 'yes',
                ],
            ]
        );

        // info label
        $repeater->add_control(
            'info_label',
            [
                'label'       => __( 'Info Label', 'mojito-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Info Label', 'mojito-core' ),
                'label_block' => true,
            ]
        );

        // info text
        $repeater->add_control(
            'info_text',
            [
                'label'       => __( 'Info Text', 'mojito-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __( 'Info Text', 'mojito-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => ['style_6'],
                ],
            ]
        );

        // enable link
        $repeater->add_control(
            'enable_link',
            [
                'label'        => __( 'Enable Link', 'mojito-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'mojito-core' ),
                'label_off'    => __( 'Hide', 'mojito-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $repeater->add_control(
            'link_type',
            [
                'label'          => __( 'Choose Link Type', 'mojito-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'url'   => [
                        'title' => __( 'URL', 'mojito-core' ),
                        'icon'  => 'far fa-globe',
                    ],
                    'email' => [
                        'title' => __( 'Email', 'mojito-core' ),
                        'icon'  => 'fa fa-envelope',
                    ],
                    'phone' => [
                        'title' => __( 'Phone', 'mojito-core' ),
                        'icon'  => 'fa fa-phone',
                    ],
                ],
                'default'        => 'icon',
                'toggle'         => false,
                'style_transfer' => true,
                'condition'      => [
                    'enable_link' => 'yes',
                ],
            ]
        );

        // list_link
        $repeater->add_control(
            'list_link',
            [
                'label'       => __( 'Link', 'mojito-core' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'default'     => [
                    'url' => '#',
                ],
                'condition'   => [
                    'enable_link' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'list_items',
            [
                'label'       => __( 'Info Lists', 'mojito-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'info_label' => __( 'Info Text', 'mojito-core' ),
                    ],
                ],
                'title_field' => '{{{ info_label }}}',
            ]
        );

        // aling items
        $this->add_responsive_control(
            'align_items',
            [
                'label'   => __( 'Alignment', 'mojito-core' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left'   => [
                        'title' => __( 'Left', 'mojito-core' ),
                        'icon'  => 'eicon-h-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'mojito-core' ),
                        'icon'  => 'eicon-h-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'mojito-core' ),
                        'icon'  => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'left',
            ]
        );

        // justify content
        $this->add_responsive_control(
            'justify_content',
            [
                'label'   => __( 'Justify Content', 'mojito-core' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => __( 'Start', 'mojito-core' ),
                        'icon'  => 'eicon-v-align-top',
                    ],
                    'center'     => [
                        'title' => __( 'Center', 'mojito-core' ),
                        'icon'  => 'eicon-v-align-middle',
                    ],
                    'flex-end'   => [
                        'title' => __( 'End', 'mojito-core' ),
                        'icon'  => 'eicon-v-align-bottom',
                    ],
                ],
                'default' => 'flex-start',
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {

        // count style
        $this->start_controls_section(
            '_section_label_style',
            [
                'label' => __( 'Icon Style', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        // icon color
        $this->add_control(
            'icon_color',
            [
                'label'     => __( 'Icon Color', 'mojito-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems i' => 'color: {{VALUE}};',
                ],
            ]
        );

        // icon bg color
        $this->add_control(
            'icon_bg_color',
            [
                'label'     => __( 'Icon Background Color', 'mojito-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems i' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // count end
        $this->end_controls_section();

        // text style
        $this->start_controls_section(
            '_section_text_style',
            [
                'label' => __( 'Text', 'mojito-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        // margin bottom
        $this->add_responsive_control(
            'text_margin_bottom',
            [
                'label'      => __( 'Margin Bottom', 'mojito-core' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min'  => 0,
                        'max'  => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .tx-listItems li:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // text color
        $this->add_control(
            'text_color',
            [
                'label'     => __( 'Color', 'mojito-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems li' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-listItems a'  => 'color: {{VALUE}};',
                ],
            ]
        );

        // bottom border color
        $this->add_control(
            'bottom_border_color',
            [
                'label'     => __( 'Bottom Border Color', 'mojito-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems li::before' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .tx-listItems a::before'  => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // bottom border color
        $this->add_control(
            'bottom_border_color_2',
            [
                'label'     => __( 'Bottom Border Color', 'mojito-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems li a:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        // hover color
        $this->add_control(
            'hover_color',
            [
                'label'     => __( 'Hover Color', 'mojito-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems li:hover'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-listItems li:hover a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-listItems li::after'  => 'background: {{VALUE}};',
                    '{{WRAPPER}} .tx-listItems a::before'  => 'background: {{VALUE}}; ',
                    '{{WRAPPER}} .tx-listItems a:hover'    => 'color: {{VALUE}};',
                ],
            ]
        );

        // hover border color
        $this->add_control(
            'hover_border_color',
            [
                'label'     => __( 'Hover Border Color', 'mojito-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems li:hover::after'   => 'background: {{VALUE}};',
                    '{{WRAPPER}} .tx-listItems li:hover a::after' => 'background: {{VALUE}};',
                ],
            ]
        );

        // text typography
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'text_typography',
                'label'    => __( 'Typography', 'mojito-core' ),
                'selector' => '
                {{WRAPPER}} .tx-listItems li,
                {{WRAPPER}} .tx-listItems a,
                {{WRAPPER}} .tx-listItems span
                ',
            ]
        );

        // text end
        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty( $settings['design_style'] ) ? $settings['design_style'] : 'style_1';

        switch ( $style ) {

        case 'style_10':
            include $dir . '/views/view-10.php';
            break;
        case 'style_9':
            include $dir . '/views/view-9.php';
            break;
        case 'style_8':
            include $dir . '/views/view-8.php';
            break;
        case 'style_7':
            include $dir . '/views/view-7.php';
            break;
        case 'style_6':
            include $dir . '/views/view-6.php';
            break;
        case 'style_5':
            include $dir . '/views/view-5.php';
            break;
        case 'style_4':
            include $dir . '/views/view-4.php';
            break;
        case 'style_3':
            include $dir . '/views/view-3.php';
            break;
        case 'style_2':
            include $dir . '/views/view-2.php';
            break;
        default:
            include $dir . '/views/view-1.php';
        }
    }
}
