<div class="mt-award-item d-flex justify-content-between align-items-center position-relative flex-wrap">
    <?php if(!empty( $settings['info_image']['url'] )) : ?>
    <div class="award-img position-absolute">
        <img src="<?php echo esc_url( $settings['info_image']['url'] ); ?>"
        alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['info_image']['url'] ); } ?>" />
    </div>
    <?php endif; ?>
    <div class="item-year-title d-flex align-items-center">
        <?php if(!empty( $settings['year'] )) : ?>
        <div class="item-year">
            <?php echo esc_html($settings['year']); ?>
        </div>
        <?php endif; ?>
        <div class="item-title headline pera-content">
            <?php if(!empty( $settings['title'] )) : ?>
            <h3><a href="<?php echo esc_url($settings['button_link']['url']); ?>"
                target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                rel= "<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                    <?php echo elh_element_kses_intermediate( $settings['title'] ); ?>
                </a></h3>
            <?php endif; ?>
            <?php if(!empty( $settings['description'] )) : ?>
            <p><?php echo elh_element_kses_intermediate( $settings['description'] ); ?></p>
            <?php endif; ?>
        </div>
    </div>
    <?php if(!empty( $settings['button_icon'] )) : ?>
    <div class="item-arrow">
        <a href="<?php echo esc_url($settings['button_link']['url']); ?>"
            target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
            rel= "<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
            <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );  ?>
        </a>
    </div>
    <?php endif; ?>
</div>