<?php
    $wow_animation = '';
    $wow_duration = '';
    $wow_delay = '';
    if ( $settings['enable_animation'] === 'yes' ) {
        $wow_animation = 'wow ' . $settings['wow_animation'];
        $wow_duration = $settings['wow_duration'] ? $settings['wow_duration'] : '1000ms';
        $wow_delay = $settings['wow_delay'] ? $settings['wow_delay'] : '200ms';
    }
?>
<div class="mt-problem-solution-item d-flex flex-wrap justify-content-between position-relative <?php echo esc_attr($wow_animation) ?>"
data-wow-delay="<?php echo esc_attr($wow_delay); ?>"
data-wow-duration="<?php echo esc_attr($wow_duration); ?>">
    <div class="item-year-title d-flex">
        <?php if(!empty( $settings['year'] )) : ?>
        <div class="mt-year">
            <span><?php echo esc_html($settings['year']); ?></span>
        </div>
        <?php endif; ?>

        <div class="item-title headline pera-content">
            <?php if(!empty( $settings['title'] )) : ?>
            <h3 class="href-underline">
                <a href="<?php echo esc_url($settings['button_link']['url']); ?>"
                target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                rel= "<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                    <?php echo elh_element_kses_intermediate( $settings['title'] ); ?>
                </a>
            </h3>
            <?php endif; ?>

            <?php if(!empty( $settings['description'] )) : ?>
            <p><?php echo elh_element_kses_intermediate( $settings['description'] ); ?></p>
            <?php endif; ?>
        </div>
    </div>
    <?php if(!empty( $settings['info_image']['url'] )) : ?>
    <div class="item-img position-absolute">
        <img src="<?php echo esc_url( $settings['info_image']['url'] ); ?>"
    alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['info_image']['url'] ); } ?>" />
    </div>
    <?php endif; ?>

    <?php if(!empty( $settings['button_text'] )) : ?>
    <div class="item-tag">
        <a  href="<?php echo esc_url($settings['button_link']['url']); ?>"
            target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
            rel= "<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
            <?php echo esc_html($settings['button_text']); ?>
        </a>
    </div>
    <?php endif; ?>
</div>