<div class="mt-portfolio-item-4">
<?php if(!empty( $settings['info_image']['url'] )) : ?>
    <div class="item-img">
    <img src="<?php echo esc_url( $settings['info_image']['url'] ); ?>"
    alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['info_image']['url'] ); } ?>" />
    </div>
<?php endif; ?>
    <div class="item-text">
        <?php if( $settings['enable_tag_lists'] === 'yes' ) : ?>
        <div class="item-cate">
            <?php foreach($settings['tag_lists'] as $lsit) : ?>
            <a href="<?php echo esc_url($lsit['tag_link']['url']); ?>"
            target="<?php echo esc_attr($lsit['tag_link']['is_external'] ? '_blank' : '_self'); ?>"
            rel= "<?php echo esc_attr($lsit['tag_link']['nofollow'] ? 'nofollow' : ''); ?>">
                <?php echo esc_html($lsit['tag_text']); ?>
            </a>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <?php if(!empty( $settings['title'] )) : ?>
        <h3 class="port_title href-underline">
            <a href="<?php echo esc_url($settings['button_link']['url']); ?>"
            target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
            rel= "<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                <?php echo elh_element_kses_intermediate( $settings['title'] ); ?>
            </a>
        </h3>
        <?php endif; ?>

        <?php if(!empty( $settings['button_text'] )) : ?>
        <a class="read_more text-uppercase" href="<?php echo esc_url($settings['button_link']['url']); ?>"
            target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
            rel= "<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
            <?php echo esc_html($settings['button_text']); ?>
            <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] );  ?>
        </a>
        <?php endif; ?>
    </div>
</div>