<?php
    $wow_animation = '';
    $wow_duration = '';
    $wow_delay = '';
    if ( $settings['enable_animation'] === 'yes' ) {
        $wow_animation = 'wow ' . $settings['wow_animation'];
        $wow_duration = $settings['wow_duration'] ? $settings['wow_duration'] : '1000ms';
        $wow_delay = $settings['wow_delay'] ? $settings['wow_delay'] : '200ms';
    }
?>
<div class="tx-iconBox <?php echo esc_attr($wow_animation) ?>"
data-wow-delay="<?php echo esc_attr($wow_delay); ?>"
data-wow-duration="<?php echo esc_attr($wow_duration); ?>">
    <div class="mt-service-item-5 text-center m-0">
        <?php if( $settings['enable_icon'] == true ) : ?>
        <div class="item-icon d-flex justify-content-center align-items-center">
            <?php if ( $settings['type'] == 'icon' ): ?>
                <?php \Elementor\Icons_Manager::render_icon( $settings['info_icon'], ['aria-hidden' => 'true'] );?>
            <?php else: ?>
                <img src="<?php echo esc_url( $settings['info_image']['url'] ); ?>" alt="<?php if(function_exists('mojito_img_alt_text')) { echo mojito_img_alt_text( $settings['info_image']['url'] ); } ?>" />
            <?php endif;?>
        </div>
        <?php endif; ?>
        <div class="item-text headline pera-content">
            <?php if(!empty( $settings['title'] )) : ?>
            <h3 class="ser_title href-underline">
                <a href="<?php echo esc_url($settings['button_link']['url']); ?>"
                target="<?php echo esc_attr($settings['button_link']['is_external'] ? '_blank' : '_self'); ?>"
                rel="<?php echo esc_attr($settings['button_link']['nofollow'] ? 'nofollow' : ''); ?>">
                    <?php echo elh_element_kses_intermediate( $settings['title'] ); ?>
                </a>
            </h3>
            <?php endif; ?>
            <?php if(!empty( $settings['description'] )) : ?>
            <p><?php echo elh_element_kses_intermediate( $settings['description'] ); ?></p>
            <?php endif; ?>
        </div>
    </div>
</div>